﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// テスト用のヘッダ
#include <nn/os.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/nn_ErrorResult.h>

#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>

// テスト対象のヘッダ
#include <../../../../../Programs/Eris/Sources/Libraries/ngc/succinct/ngc_AhoCorasick.h>
#include <../../../../../Programs/Eris/Sources/Libraries/ngc/succinct/ngc_MemoryInputStream.h>
#include "./testNgc_AcAutomaton.h"

namespace {

/**
 * @brief   テストに与えるパラメータです。
 */
enum AcTestParam
{
    AcTestParam_UseMalloc               = 0,    //!< デフォルトのアロケータ(std::malloc)を利用する
    AcTestParam_UseWorkBufAllocator             //!< nn::ngc::detail::WorkBufAllocator を利用する
};


// AhoCorasick::Match() 時に呼び出されるコールバック
bool MatchCallback(const char* first, const char* last, uint32_t nodeid, void* user_obj)
{
    NN_UNUSED(first);
    NN_UNUSED(last);
    NN_UNUSED(nodeid);
    int* pCount = reinterpret_cast<int*>(user_obj);
    *pCount += 1;
    return true;
}

/**
 * @brief   テストで利用するテストフィクスチャです。
 */
class SuccinctAhoCorasickTest : public ::testing::TestWithParam<int>
{
protected:

    SuccinctAhoCorasickTest() NN_NOEXCEPT : m_HeapSize(128 * 1024), m_HeapAddr(NULL), m_Ac(), m_Allocator() {}

    /**
     * @brief   テスト開始時に毎回呼び出される関数です。
     */
    virtual void SetUp()
    {
        if (GetParam() == AcTestParam_UseWorkBufAllocator)
        {
            m_HeapAddr = std::malloc(m_HeapSize);
            NN_ABORT_UNLESS(m_HeapAddr);
            m_Allocator.Initialize(m_HeapAddr, m_HeapSize);
            m_Ac.SetAllocator(&m_Allocator);
        }
    }

    /**
     * @brief   テスト終了時に毎回呼び出される関数です。
     */
    virtual void TearDown()
    {
        if (GetParam() == AcTestParam_UseWorkBufAllocator)
        {
            m_Ac.ReleaseAllocator();
            m_Allocator.Finalize();
            std::free(m_HeapAddr);
        }
    }

protected:
    const size_t m_HeapSize;
    void* m_HeapAddr;                               // ワークバッファ用メモリ
    nn::ngc::detail::AhoCorasick m_Ac;              // テスト対象 AhoCorasick
    nn::ngc::detail::WorkBufAllocator m_Allocator;  // ワークバッファ用アロケータ
};

}   // namespace

TEST_P(SuccinctAhoCorasickTest, Simple)
{

    nn::ngc::detail::BinaryReader reader;
    nn::ngc::detail::MemoryInputStream stream;

    // AC の読み込み
    stream.Init(nn::ngc::detail::pAcJapaneseNotB, sizeof(nn::ngc::detail::pAcJapaneseNotB));
    reader.Init(reader.EndianSetting_EndianLittle);
    reader.Open(&stream);
    m_Ac.Import(&reader);
    reader.Close();
    stream.Close();

    // マッチング処理
    auto DoTest = [](nn::ngc::detail::AhoCorasick* pAc, int answer)
    {
        char pText[] = "I am fuckin fuck boy.\n";
        int count = 0;
        pAc->Match(pText, MatchCallback, &count);
        EXPECT_EQ(count, answer);    // pAcJapaneseNotB なら "fuck" にマッチする
    };

    DoTest(&m_Ac, 2);

    // ムーブの確認
    nn::ngc::detail::AhoCorasick ac(std::move(m_Ac));
    DoTest(&ac, 2);
    m_Ac = std::move(ac);
    DoTest(&m_Ac, 2);

    // Reset() の確認
    m_Ac.Reset();
    stream.Init(nn::ngc::detail::pAcJapaneseB2, sizeof(nn::ngc::detail::pAcJapaneseB2));
    reader.Init(reader.EndianSetting_EndianLittle);
    reader.Open(&stream);
    m_Ac.Import(&reader);
    reader.Close();
    stream.Close();
    DoTest(&m_Ac, 0);
}

INSTANTIATE_TEST_CASE_P(SwitchAllocator,
                        SuccinctAhoCorasickTest,
                        testing::Values(AcTestParam_UseMalloc,
                                        AcTestParam_UseWorkBufAllocator));
