﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/oe.h>
#include <nn/nn_Common.h>
#include <nn/hid.h>
#include <nn/nn_Log.h>
#include <nn/os/os_Event.h>
#include <nn/hid/system/hid_Npad.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>

#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>

#include <nnt/nfp/testMifare_Common.h>

//================================================================================
// 全プラットフォームで共通のテストスイートです。
// 必ずタグを設置せずにテストを開始してください。
//================================================================================

class MifareAutoWithoutTag : public nnt::mifare::TestFramework
{
protected:

    MifareAutoWithoutTag() NN_NOEXCEPT
    {
        // oeライブラリを初期化します。実機のみ
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
        nn::oe::Initialize();
#endif //defined(NN_BUILD_CONFIG_OS_HORIZON)
        // コントローラの初期化
        nnt::mifare::InitializeHidController();
        // API呼び出しログ出力フラグ
        //nnt::mifare::wrapper::SetApiCallLoggingMode(nnt::mifare::wrapper::LogMode_Aging);
    }

    ~MifareAutoWithoutTag() NN_NOEXCEPT
    {
    }

    virtual void SetUp() NN_NOEXCEPT NN_OVERRIDE
    {
    }

    virtual void TearDown() NN_NOEXCEPT NN_OVERRIDE
    {
        // 次のテストに影響が出ないようにライブラリを一旦終了しておきます。
        if(nnt::mifare::wrapper::GetState() == NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::State_Init)
        {
            nnt::mifare::FinalizeSystem();
        }
    }
};

//================================================================================
// テストスイート全体で共通の処理です。
//================================================================================

//================================================================================
// テストケースの実装です。
//================================================================================
TEST_F(MifareAutoWithoutTag, TestCaseGoodOperationDeviceSearch)
{
    // デバイス状態がSearch時に呼び出すことができるAPIのテストをします。
    NN_LOG("TestCaseGoodOperationDeviceSearch start\n");

    // 状態をSearchに遷移させる
    nnt::mifare::DoSearch();

    // ----------------------------------------
    // テスト対象 : nn::nfc::mifare::StopDetection()
    //              nn::nfc::mifare::GetDeviceState()
    //              nn::nfc::mifare::GetNpadId()
    //              nn::nfc::mifare::ListDevices()
    //              nn::nfc::mifare::AttachActivateEvent()
    //              nn::nfc::mifare::AttachDeactivateEvent()
    // ----------------------------------------
    EXPECT_EQ(NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::State_Init, nnt::mifare::wrapper::GetState());
    EXPECT_EQ(NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::DeviceState_Search, nnt::mifare::wrapper::GetDeviceState());
    nn::hid::NpadIdType npadId;
    NNT_EXPECT_RESULT_SUCCESS(nnt::mifare::wrapper::GetNpadId(&npadId));
    nnt::mifare::CheckNPadId(npadId);
    int outCount;
    NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::DeviceHandle currentDeviceHandle;
    NNT_EXPECT_RESULT_SUCCESS(
            nnt::mifare::wrapper::ListDevices(&currentDeviceHandle, &outCount, 1));
    nn::os::SystemEventType activateEvent;
    nn::os::SystemEventType deactivateEvent;
    NNT_EXPECT_RESULT_SUCCESS(nnt::mifare::wrapper::AttachActivateEvent(&activateEvent));
    NNT_EXPECT_RESULT_SUCCESS(nnt::mifare::wrapper::AttachDeactivateEvent(&deactivateEvent));
    nn::os::DestroySystemEvent(&activateEvent);
    nn::os::DestroySystemEvent(&deactivateEvent);
    NNT_EXPECT_RESULT_SUCCESS(nnt::mifare::wrapper::StopDetection());
    EXPECT_EQ(NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::State_Init, nnt::mifare::wrapper::GetState());
    EXPECT_EQ(NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::DeviceState_Init, nnt::mifare::wrapper::GetDeviceState());
}

TEST_F(MifareAutoWithoutTag, TestCaseInvalidOperationDeviceSearch)
{
    // デバイス状態がSearch時に呼び出すことができるAPIのテストをします。
    NN_LOG("TestCaseInvalidOperationDeviceSearch start\n");

    // 状態をSearchに遷移させる
    nnt::mifare::DoSearch();

    // ----------------------------------------
    // テスト対象 : nn::nfc::mifare::StartDetection()
    //              nn::nfc::mifare::Read()
    //              nn::nfc::mifare::Write()
    //              nn::nfc::mifare::GetTagInfo()
    // ----------------------------------------
    NNT_EXPECT_RESULT_FAILURE(NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::ResultInvalidDeviceState,
            nnt::mifare::wrapper::StartDetection());
    const int blockCount = 2;
    NNT_NFC_COMMON_IF_TYPE_MIFARE(ReadBlockData) readBlockData[blockCount] = {};
    NNT_NFC_COMMON_IF_TYPE_MIFARE(ReadBlockParameter) readBlockParameter[blockCount] = {};
    NNT_NFC_COMMON_IF_TYPE_MIFARE(WriteBlockParameter) writeBlockParameter[blockCount] = {};
    nnt::mifare::PrepareWriteParam(writeBlockParameter, blockCount);
    NNT_EXPECT_RESULT_FAILURE(NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::ResultInvalidDeviceState,
            nnt::mifare::wrapper::Write(writeBlockParameter, blockCount));
    nnt::mifare::PrepareReadParam(readBlockParameter, blockCount);
    NNT_EXPECT_RESULT_FAILURE(NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::ResultInvalidDeviceState,
            nnt::mifare::wrapper::Read(readBlockData, readBlockParameter, blockCount));
    NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::TagInfo tagInfo;
    NNT_EXPECT_RESULT_FAILURE(NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::ResultInvalidDeviceState,
            nnt::mifare::wrapper::GetTagInfo(&tagInfo));
}
