@echo off

rem Usage: launch_net_servers.bat <optional_platforms>

rem Available platforms: Https,HttpsVirtual,HttpsNormal,HttpsExpired,HttpsCrl,HttpsCache,HttpsShim,Dns,Http,Proxy,ProxyNoCred

echo .
echo *********************************************************************************
echo * The Https platforms have a predetermined NGINX configuration.
echo * You may override the NGINX configuration by defining NNTEST_NGINX_CONFIG
echo *
echo * Available platforms:
echo *  - Https         (Defaults to HttpsVirtual)
echo *  - HttpsVirtual  (Uses config with several virtual hosts: natf.com, natf_2.com, natf_3.com)
echo *  - HttpsNormal   (Single non-virtual host)
echo *  - HttpsExpired  (Uses virtual hosts with different expired certs)
echo *  - HttpsCrl      (Uses two different servers that use revoked certs for testing CRL)
echo *  - HttpsCache    (Uses single server that enables ssl session cache)
echo *  - HttpsShim     (Uses several non-virtual host servers for testing Tests/Net/Sources/Tests/Ssl)
echo *  - Dns           (Dns server used to resolve: natf.com, natf_2.com and natf_3.com)
echo *  - Http          (Launches http server without SSL)
echo *  - Proxy         (Proxy server with username/password credentials requried)
echo *  - ProxyNoCred   (Proxy server without any credentials requried)
echo *
echo * You should run kill_natf.bat to shutdown the servers when finished.
echo *********************************************************************************
echo .

rem Construct platform parameters
if not "%6" == "" (
    set PLATFORMS=%1,%2,%3,%4,%5,%6
) else if not "%5" == "" (
    set PLATFORMS=%1,%2,%3,%4,%5
) else if not "%4" == "" (
    set PLATFORMS=%1,%2,%3,%4
) else if not "%3" == "" (
    set PLATFORMS=%1,%2,%3
) else if not "%2" == "" (
    set PLATFORMS=%1,%2
) else if not "%1" == "" (
    set PLATFORMS=%1
) else (
    rem Use default parameters
    set PLATFORMS=Https,Dns,Proxy
)

if "%NNTEST_NGINX_CONFIG%" == "" (
    if not "x%PLATFORMS:HttpsVirtual=%"=="x%PLATFORMS%" (
        set TEMP_PLATFORMS=%PLATFORMS:HttpsVirtual=%
        set PLATFORMS=%PLATFORMS:HttpsVirtual=Https%
        set NNTEST_NGINX_CONFIG_PASS=%NINTENDO_SDK_ROOT%\Tests\Net\Resources\NginxConfig\nginx-virtual.conf
    ) else if not "x%PLATFORMS:HttpsNormal=%"=="x%PLATFORMS%" (
        set TEMP_PLATFORMS=%PLATFORMS:HttpsNormal=%
        set PLATFORMS=%PLATFORMS:HttpsNormal=Https%
        set NNTEST_NGINX_CONFIG_PASS=%NINTENDO_SDK_ROOT%\Tests\Net\Resources\NginxConfig\nginx-normal.conf
    ) else if not "x%PLATFORMS:HttpsExpired=%"=="x%PLATFORMS%" (
        set TEMP_PLATFORMS=%PLATFORMS:HttpsExpired=%
        set PLATFORMS=%PLATFORMS:HttpsExpired=Https%
        set NNTEST_NGINX_CONFIG_PASS=%NINTENDO_SDK_ROOT%\Tests\Net\Resources\NginxConfig\nginx-expired.conf
    ) else if not "x%PLATFORMS:HttpsCrl=%"=="x%PLATFORMS%" (
        set TEMP_PLATFORMS=%PLATFORMS:HttpsCrl=%
        set PLATFORMS=%PLATFORMS:HttpsCrl=Https%
        set NNTEST_NGINX_CONFIG_PASS=%NINTENDO_SDK_ROOT%\Tests\Net\Resources\NginxConfig\nginx-crl.conf
    ) else if not "x%PLATFORMS:HttpsCache=%"=="x%PLATFORMS%" (
        set TEMP_PLATFORMS=%PLATFORMS:HttpsCache=%
        set PLATFORMS=%PLATFORMS:HttpsCache=Https%
        set NNTEST_NGINX_CONFIG_PASS=%NINTENDO_SDK_ROOT%\Tests\Net\Resources\NginxConfig\nginx-ssl-cache.conf
    ) else if not "x%PLATFORMS:HttpsShim=%"=="x%PLATFORMS%" (
        set TEMP_PLATFORMS=%PLATFORMS:HttpsShim=%
        set PLATFORMS=%PLATFORMS:HttpsShim=Https%
        set NNTEST_NGINX_CONFIG_PASS=%NINTENDO_SDK_ROOT%\Tests\Net\Resources\NginxConfig\nginx-sll-shim.conf
    ) else if not "x%PLATFORMS:Https=%"=="x%PLATFORMS%" (
        set TEMP_PLATFORMS=%PLATFORMS:Https=%
        set NNTEST_NGINX_CONFIG_PASS=%NINTENDO_SDK_ROOT%\Tests\Net\Resources\NginxConfig\nginx-virtual.conf
    )
) else (
    set NNTEST_NGINX_CONFIG_PASS=%NNTEST_NGINX_CONFIG%
)

set TEMP_PLATFORMS_2=%TEMP_PLATFORMS:Http=%
if not "%TEMP_PLATFORMS%"=="%TEMP_PLATFORMS_2%" (
    echo "** ERROR! ** Cannot Launch more than 1 type of Http(s) server at a time."
    goto :OUT
)

echo Nginx Config: "%NNTEST_NGINX_CONFIG_PASS%"

echo %~dp0../../Integrate/Scripts/Testlist/NetworkTestServers.testlist.yml > %~dp0\temp_params.txt

call %~dp0\run_net_param_file.bat %~dp0\temp_params.txt %PLATFORMS%

del %~dp0\temp_params.txt

:OUT
