﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 Test process for Network
 *---------------------------------------------------------------------------*/

#include "NetTest_Port.h"

#include "Tests/TcpUdpLoopbackTest.h"
#include "Utils/CommandLineParser.h"

#include <nnt/nntest.h>

// TcpUdpLoopback
TEST(natf, TcpUdpLoopback)
{
    bool isSuccess;

    NATF::Utils::ParserGroup parser;
    nn::util::Uuid netProfile;
    int defaultTimeoutMs = 300;
    int defaultDurationSec = 30;
    int32_t timeoutMs;
    int32_t durationSec;
    int defaultPortNumber = 8001;
    int32_t portNumber;
    int defaultConnectionCount = 2;
    int32_t connectionCount;
    char protocolTypeName[NATF::Modules::SoTestDataXfer::MaxNameStringLen];
    char pTestName[NATF::BaseTest::NameBufferLen];
    char clientXferPattern[NATF::Modules::SoTestDataXfer::MaxBufSize];
    char serverXferPattern[NATF::Modules::SoTestDataXfer::MaxBufSize];

    int argC;
    const char * const * argV;

    memset((void *)clientXferPattern, '\0', sizeof(clientXferPattern));
    memset((void *)serverXferPattern, '\0', sizeof(serverXferPattern));

    NN_NETTEST_LOG("\nEnter NATF Process\n\n");

    NETTEST_GET_ARGS(argC, argV);

    parser.AddParser(NATF::Utils::StringParser  ("--Name", nullptr, pTestName, sizeof(pTestName)));
    parser.AddParser(NATF::Utils::UuidParser    ("--NetProfile", &nn::util::InvalidUuid, netProfile));
    parser.AddParser(NATF::Utils::Int32Parser   ("--TimeoutMs", &defaultTimeoutMs, timeoutMs));
    parser.AddParser(NATF::Utils::Int32Parser   ("--PortNumber", &defaultPortNumber, portNumber));
    parser.AddParser(NATF::Utils::StringParser  ("--ProtocolType", nullptr, protocolTypeName, sizeof(protocolTypeName)));
    parser.AddParser(NATF::Utils::Int32Parser   ("--DurationSec", &defaultDurationSec, durationSec));
    parser.AddParser(NATF::Utils::Int32Parser   ("--ConnectionCount", &defaultConnectionCount, connectionCount));
    parser.AddParser(NATF::Utils::StringParser  ("--ClientXferPattern", "Echo", clientXferPattern, sizeof(clientXferPattern)));
    parser.AddParser(NATF::Utils::StringParser  ("--ServerXferPattern", "Echo", serverXferPattern, sizeof(serverXferPattern)));

    if( !parser.Parse(argC, argV) )
    {
        NN_NETTEST_LOG(" * Failed to parse command line arguments!\n\n");
        EXPECT_EQ(false, true);
        return;
    }

    NATF::Tests::TcpUdpLoopback TcpUdpLoopback(pTestName, netProfile, timeoutMs, portNumber, protocolTypeName, durationSec, connectionCount, clientXferPattern, serverXferPattern);

    isSuccess = TcpUdpLoopback.Run();
    EXPECT_EQ(isSuccess, true);

    NN_NETTEST_LOG("\nExit NATF Process\n\n");
}
