﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ParseHelpers.h"
#include <nn/ssl/ssl_Connection.h>
#include <nn/nn_Log.h>
#include <cstring>

#include <curl/curl.h>

namespace nnt {
    bool ParserHelpers::GetCacheModeFromString(const char* pString, uint32_t strBufLen, nn::ssl::Connection::SessionCacheMode& outCacheMode) NN_NOEXCEPT
    {
        if(strncmp(pString, "NONE", strBufLen) == 0)
        {
            outCacheMode = nn::ssl::Connection::SessionCacheMode::SessionCacheMode_None;
        }
        else if(strncmp(pString, "ID", strBufLen) == 0)
        {
            outCacheMode = nn::ssl::Connection::SessionCacheMode::SessionCacheMode_SessionId;
        }
        else if(strncmp(pString, "TICKET", strBufLen) == 0)
        {
            outCacheMode = nn::ssl::Connection::SessionCacheMode::SessionCacheMode_SessionTicket;
        }
        else
        {
            NN_LOG("\n ERROR: Unknown session cache mode: %s\n Valid modes: None, Id, Ticket\n\n", pString);
            return false;
        }

        return true;
    }

    bool ParserHelpers::GetProxyAuthFromString(const char* pString, uint32_t strBufLen, int& outProxyAuth) NN_NOEXCEPT
    {
        if( strncmp(pString, "NONE", strBufLen) == 0 )
        {
            outProxyAuth = CURLAUTH_NONE;
        }
        else if( strncmp(pString, "BASIC", strBufLen) == 0 )
        {
            outProxyAuth = CURLAUTH_BASIC;
        }
        else if( strncmp(pString, "DIGEST", strBufLen) == 0 )
        {
            outProxyAuth = CURLAUTH_DIGEST;
        }
        else if( strncmp(pString, "NEGOTIATE", strBufLen) == 0 )
        {
            outProxyAuth = CURLAUTH_NEGOTIATE;
        }
        else
        {
            NN_LOG("\n * Failed to get proxy auth from string. Valid values: None, Basic, Digest, Negotiate.\n\n");
            return false;
        }

        return true;
    }

    bool ParserHelpers::GetWaitTypeFromString(const char* pString, uint32_t strBufLen, bool& outUseSelect) NN_NOEXCEPT
    {
        if( strncmp(pString, "SELECT", strBufLen) == 0 )
        {
            outUseSelect = true;
        }
        else if( strncmp(pString, "POLL", strBufLen) == 0 )
        {
            outUseSelect = false;
        }
        else
        {
            NN_LOG(" Failed to get wait type from string. Valid inputs: Select, Poll\n\n");
            return false;
        }

        return true;
    }
} // nnt
