﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

const char g_pTestRootCaCert[] =
"-----BEGIN CERTIFICATE-----\n"
"MIIDdDCCAlygAwIBAgIJAJJPVlK2uFXTMA0GCSqGSIb3DQEBCwUAMEcxEzARBgNV\n"
"BAoMClNpbXBsZSBJbmMxFzAVBgNVBAsMDlNpbXBsZSBSb290IENBMRcwFQYDVQQD\n"
"DA5TaW1wbGUgUm9vdCBDQTAeFw0xNzA4MjMxNjE1NTFaFw0zNzA4MTgxNjE1NTFa\n"
"MEcxEzARBgNVBAoMClNpbXBsZSBJbmMxFzAVBgNVBAsMDlNpbXBsZSBSb290IENB\n"
"MRcwFQYDVQQDDA5TaW1wbGUgUm9vdCBDQTCCASIwDQYJKoZIhvcNAQEBBQADggEP\n"
"ADCCAQoCggEBAMBoYrvGnVf1fUUMya1M9wqFw2pxgDq5yZ2Lg1ZCp9qq1W6qVhYj\n"
"9Bl25x7jVhjPDr5zcmUc3wogEjN6+2ldGR0DtssWwizuEk0gZS2jaChStNApccEw\n"
"Trf8/HJ8qDjrf2EM5mersgtQsfoylgVQGaOmgcbtuWcXHAtNCJLr+WaLEqaD+2J3\n"
"IM4K3gOSQdv+EORuPBix6KY/a0zhXyB+pGc9cZk1hp7yV4FyLrPQZ4OvAJeArF2r\n"
"8VgxfPhxkO2kb19sw1LSXHktZBHkzZkw6zvDW/FnpVa25y2iOvY2mjIkkUvsxcqv\n"
"BGRhHluWxizNjnZfw7CpyZiE3G6aQrmD+n8CAwEAAaNjMGEwHQYDVR0OBBYEFBAy\n"
"UTzpSvrewZYBrjY5aL9ZusoHMB8GA1UdIwQYMBaAFBAyUTzpSvrewZYBrjY5aL9Z\n"
"usoHMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgGGMA0GCSqGSIb3DQEB\n"
"CwUAA4IBAQCVzrN2zM3SkmH3Pl+uYdC4Z5v9hCi9VWeLaliS/MSysJeIpLTmeW+4\n"
"f2ld9CxBbMyX2tBHdQOK9kyya2ZeQA2xRjVgbEKAb64LLQHh8jgY/m5q+yQV0wyM\n"
"GIgHk40FJfwHK+j8BOihoEQFyub3zNMXfGK6ZZh65K45FKbZyo6pxeTo7CnymJMN\n"
"++1seTVwMv3khuSBOktG11ZSp3DiJH5/snZGQf1C9hC35IwPy2ApqJtOClCP/63N\n"
"NzcN4/2RUr7fZJycNBC3Sn5fOh5FbrjUaQll9QgTZAY0rPphvD0hkOXMsmjEnlrA\n"
"HVTqWn4CDwZef1B/ItD1FIgdGtgrMw8b\n"
"-----END CERTIFICATE-----";

const char g_pTestSigningCaCert[] =
"-----BEGIN CERTIFICATE-----\n"
"MIIDdzCCAl+gAwIBAgIDMNQAMA0GCSqGSIb3DQEBCwUAMEcxEzARBgNVBAoMClNp\n"
"bXBsZSBJbmMxFzAVBgNVBAsMDlNpbXBsZSBSb290IENBMRcwFQYDVQQDDA5TaW1w\n"
"bGUgUm9vdCBDQTAeFw0xNzA4MjMxNjE1NTJaFw0yNzA4MjExNjE1NTJaME0xEzAR\n"
"BgNVBAoMClNpbXBsZSBJbmMxGjAYBgNVBAsMEVNpbXBsZSBTaWduaW5nIENBMRow\n"
"GAYDVQQDDBFTaW1wbGUgU2lnbmluZyBDQTCCASIwDQYJKoZIhvcNAQEBBQADggEP\n"
"ADCCAQoCggEBALo+SKQXmbcyCFe6RdqLDuJLpsxVCo/4GMPGmoMjuhXmI0YdBq9D\n"
"QzX39qbRfuap41FEhgNmDjKVjVj5E6E3/TJJmiz7og6RPsbYDowne9QwY5P0mnqB\n"
"+A7lrtHpjM2vlXdr9k8WjBUoyyYFNeyHIRFNh+qIZC1HnmMcK8sKiyJpfTg2X6QU\n"
"WoyfrZ6Ra6ukqOUwlxZYhURJiOt6FvhmB1UnP3URF6/eg1RnU7bPHCHEUJjawXNd\n"
"8YSgw1YAks8x9e/o+c8QPlaGUldhFmW6NIPZrerrT4lclE8xBOg1njfXKuMxA6L5\n"
"Drj8FqmDZFxmLkNAB0Y6iD028Vy2UcoDpGcCAwEAAaNmMGQwHQYDVR0OBBYEFFBx\n"
"VGatSk90VZiV99d2owo+r2LoMB8GA1UdIwQYMBaAFBAyUTzpSvrewZYBrjY5aL9Z\n"
"usoHMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQDAgGGMA0GCSqGSIb3\n"
"DQEBCwUAA4IBAQAcv8cmo9CeSdaWqkegq7PzfLGhSa63UKiz4R5jr6A6rwvUnjes\n"
"3+3fow7CxoqyoxeHLGlZxmPY1Vpeptsv/9iLJFHWeBQz3rIH4glEaU0eWE4J86G3\n"
"OSONhdeF/lQdW+giGFun8tIdcBEjdBmRRs++jP/+oDjG9BkZf/pCSV3SOAtYLYzV\n"
"HSK95PD/Fm0x0QiYmbz2wrvzqlfeoC8CFz0efEEsgcxG0tXv1+IHapjS3iBQv29S\n"
"3j82+eQjcfcvDgs0T4VYmAlJfQhYNE3o0g0ugmfx6L+nESqTDfMXWfx8H+7J/lfw\n"
"8UZdfQASPHdijWlIhPcH8zCzHUsfEPeT4zJx\n"
"-----END CERTIFICATE-----\n";


const char g_pTestCaCert[] =
"-----BEGIN CERTIFICATE-----\n"
"MIIERTCCAy2gAwIBAgIDMNfoMA0GCSqGSIb3DQEBCwUAME0xEzARBgNVBAoMClNp\n"
"bXBsZSBJbmMxGjAYBgNVBAsMEVNpbXBsZSBTaWduaW5nIENBMRowGAYDVQQDDBFT\n"
"aW1wbGUgU2lnbmluZyBDQTAeFw0xNzA4MjMxNjE1NTNaFw0yNzA4MjExNjE1NTNa\n"
"MGsxEzARBgNVBAoMClNpbXBsZSBJbmMxKTAnBgNVBAsMIG50ZC1uZXQtc2VydmVy\n"
"MS5udGQubmludGVuZG8uY29tMSkwJwYDVQQDDCBudGQtbmV0LXNlcnZlcjEubnRk\n"
"Lm5pbnRlbmRvLmNvbTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMbT\n"
"LDUafOOu7dCS8sKjluVFAG8z9qxfl37l7+XXDFlFJmN0lzP+8x6MwLOrD7oGKwwY\n"
"cpPBtcDK7e9K0A8w/oFxUkhdEFB6KWzEspAis2h5tDCS7Z3bgbL7MrH8fi5OZq3C\n"
"+5XE4mh2CHEnYr4WcDA5hcWiZUsN9IXQLBeHSzDMghJVvRPGO7oRhKgK2w80uaxS\n"
"BS3Ahxc9WyOslB3HPO8NWsHTIBxQAQCR5ADiWNGTN8gHxnePxkkBB/5PefrUbDZe\n"
"JlA7Hrmu9QuWTVrwDZAKMrc9fvpD0+/wmQp+O9iAZrytM3RCf9wojRnlCiOWYWk4\n"
"I6zJJxo6Q0LJF94SAuMCAwEAAaOCAQ4wggEKMAkGA1UdEwQCMAAwEQYJYIZIAYb4\n"
"QgEBBAQDAgZAMDMGCWCGSAGG+EIBDQQmFiRPcGVuU1NMIEdlbmVyYXRlZCBTZXJ2\n"
"ZXIgQ2VydGlmaWNhdGUwHQYDVR0OBBYEFMMpKD1PMlZmzPTCELFbEnbCDpokMHEG\n"
"A1UdIwRqMGiAFFBxVGatSk90VZiV99d2owo+r2LooUukSTBHMRMwEQYDVQQKDApT\n"
"aW1wbGUgSW5jMRcwFQYDVQQLDA5TaW1wbGUgUm9vdCBDQTEXMBUGA1UEAwwOU2lt\n"
"cGxlIFJvb3QgQ0GCAzDUADAOBgNVHQ8BAf8EBAMCBaAwEwYDVR0lBAwwCgYIKwYB\n"
"BQUHAwEwDQYJKoZIhvcNAQELBQADggEBAH1L0tvnVHmstLGL4MdxWq2+MMr4Ywur\n"
"FvaCt6blFMcsLyVbmPc9g5+JqlDB7EYTS0zBI8jw7JZ/EhDJoAdcGL4nYCdNfH3k\n"
"BYA4QJa2OpTCXI0mTTQUDdGEW3AF2kqwxf8uzzSmD1xta6XWDkHsuHmUPHQKYmWH\n"
"BwlFaJuFGhvapl6/WZgyCGkmjHp52XAhMeICtwe9BkifF7a6rzjZWwFR1J2ingG9\n"
"4WBQIa+O1yCsbqqMhiwN8L1A/1eSOa9NcpDXaMgmGH7k0BYzepn1kmZMgv7sfOsZ\n"
"bwBf47O+cF+JivkEo9qnpieXf+C54FILjBsgRX/K3IjvTBC8CE7n6SU=\n"
"-----END CERTIFICATE-----";

const char g_pTestCaCertExpired[] = "-----BEGIN CERTIFICATE-----\nMIICuzCCAiQCCQCsxZGx6gDMgzANBgkqhkiG9w0BAQsFADCBoTELMAkGA1UEBhMC\nVVMxEzARBgNVBAgMCldhc2hpbmd0b24xEDAOBgNVBAcMB1JlZG1vbmQxETAPBgNV\nBAoMCE5pbnRlbmRvMS0wKwYDVQQLDCROaW50ZW5kbyBUZWNobm9sb2d5IERldmVs\nb3BtZW50IEluYy4xKTAnBgNVBAMMIG50ZC1uZXQtc2VydmVyMS5udGQubmludGVu\nZG8uY29tMB4XDTAwMDEwMjAwMTk1MFoXDTAwMDEwMzAwMTk1MFowgaExCzAJBgNV\nBAYTAlVTMRMwEQYDVQQIDApXYXNoaW5ndG9uMRAwDgYDVQQHDAdSZWRtb25kMREw\nDwYDVQQKDAhOaW50ZW5kbzEtMCsGA1UECwwkTmludGVuZG8gVGVjaG5vbG9neSBE\nZXZlbG9wbWVudCBJbmMuMSkwJwYDVQQDDCBudGQtbmV0LXNlcnZlcjEubnRkLm5p\nbnRlbmRvLmNvbTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA0nFXTfGqGDiN\nGg2RzEuLA2dHzyyZ8B/rCYeX1Hi1Ke2ipEJjpUeH7LupflI15X4eof/NHuCl6ZOz\n/daJlHTBff0H7hBjN/R/GwKgf8IG8cvS7GpENgcUIeP76EiokEaiP9cgW45O+q7H\nWURvMadQHKl2M/FzYOokdqrruZOXzqECAwEAATANBgkqhkiG9w0BAQsFAAOBgQBD\nTFQ4ETYFJzFEJX0UBGpwjUZrf8orHttbswDv4vaJNTyePVoUwjWUQvkWs2QInYL4\nh6fFPvlw4PLXDjnUBp9ZIPK7d3KTNLSJCo5GLYiAJf9FKqHW86jE6Kmm8k8MZu0O\nzjLv74Qd7P90EoiX5NeTlfRai4MnICXDozClBVO62w==\n-----END CERTIFICATE-----";
const char g_pTestCaCertInvalidFmt[] = "-----BEGIN\nMIIEOTCCAyGgAwIBAgIBATANBgkqhkiG9w0BAQUFADB6MRMwEQYKCZImiZPyLGQB\nGRYDb3JnMRYwFAYKCZImiZPyLGQBGRYGc2ltcGxlMRMwEQYDVQQKDApTaW1wbGUg\nSW5jMRowGAYDVQQLDBFTaW1wbGUgU2lnbmluZyBDQTEaMBgGA1UEAwwRU2ltcGxl\nIFNpZ25pbmcgQ0EwHhcNMTYwMTI1MjMyOTM2WhcNMTgwMTI0MjMyOTM2WjCBmDET\nMBEGCgmSJomT8ixkARkWA29yZzEWMBQGCgmSJomT8ixkARkWBnNpbXBsZTETMBEG\nA1UECgwKU2ltcGxlIEluYzEpMCcGA1UECwwgbnRkLW5ldC1zZXJ2ZXIxLm50ZC5u\naW50ZW5kby5jb20xKTAnBgNVBAMMIG50ZC1uZXQtc2VydmVyMS5udGQubmludGVu\nZG8uY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3qVVe6OeFuP8\n8ezCh/bZ02yCeS6wjM7yYaxlDETaE88//CsikUSlQFH+9mg1p8JcteG3KKeGJtla\nYehyZRHsbOraNXLUzdJb/6j9aMOxFPnlmBe9/flJFSM0NGly3UH70CtJPiBp5HyB\nH+/A/pyISdPBYkebdg0t8F2WNfO5A0/qOP3QxI5ro6k/dW0z9hMX1B2A+d5jtOkC\nmEHsnkgXp9SMDyCabM9qSECBZ6mqQVIZLg1HQA0xdIgaJ0tQvtqzcIxrQs/ZS09K\nCm5bBPPerQ9q+e6u8+UbO3UnwIuujhfO+1GzRMtC4J16mf6LdqycmNbUxn8sS8R8\nTK6QmhJHoQIDAQABo4GqMIGnMA4GA1UdDwEB/wQEAwIFoDAJBgNVHRMEAjAAMB0G\nA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUC0cFnuCaJXg/\nWU7Iotihbbv7Z3AwHwYDVR0jBBgwFoAUMAkDFn5aLSnSlX0Oa+nX46c6aQ0wKwYD\nVR0RBCQwIoIgbnRkLW5ldC1zZXJ2ZXIxLm50ZC5uaW50ZW5kby5jb20wDQYJKoZI\nhvcNAQEFBQADggEBAHgwuk87+eY2sz4DwlgghsLBkDFf0WZ+Hs05QaDCOP54C1QM\nnqU1djB448rhEo5OamhykZ/13VrhZwP7lsFYqrIG4QJCrJo4Z3d5gnG02bh08z/h\nWFHTqFNGCU5HFmG4amKoTB8VU6dlLE2aMNQnRVOrm02q4Q28mxKhynuHyE7E5vOy\nqziTQCULdO2/+ZLyKDsnUEdT/QZm5kTMjdynSrBgZ2/RPABMJOTL8yvNd3fdh33h\nyKXchj8O9AIse4DinQgEhfyh9N1K9FdK1JimvefYk3KtDxn+8Z/v6KdZ9ZD676gW\nCfpEoHxDcTOESAyxulRKp3nBRulL7zFO9OMSFnE=\n-----END C";

const char g_pTestRvkRootCa[] =
"-----BEGIN CERTIFICATE-----\n"
"MIIDkDCCAnigAwIBAgIJAOSEpRDkYbHSMA0GCSqGSIb3DQEBCwUAMFUxCzAJBgNV\n"
"BAYTAlVTMQswCQYDVQQIDAJXQTEQMA4GA1UEBwwHUmVkbW9uZDEMMAoGA1UECgwD\n"
"TlREMRkwFwYDVQQDDBByb290Lm5hdGZfMzQuY29tMB4XDTE3MDgyMzIwNTgzNFoX\n"
"DTM3MDgxODIwNTgzNFowVTELMAkGA1UEBhMCVVMxCzAJBgNVBAgMAldBMRAwDgYD\n"
"VQQHDAdSZWRtb25kMQwwCgYDVQQKDANOVEQxGTAXBgNVBAMMEHJvb3QubmF0Zl8z\n"
"NC5jb20wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDIr3MBrJ82Xt5E\n"
"qwVLSKGzRJkvhgG9dCE8prSd81nkX6S2c8bfzM1ACMsdU37a18hBke6QO6NZLEDV\n"
"CqKAVaZ7kNlRCiI0CVw5b0O4QepU1HiSHIHpBUQFRvDWd9ScmRd8mhGa6XGyS/DE\n"
"+Bz1FDvrYrOz4Q5st8JI4UMYglTT+reP8r5xTm2cTuUztD6Vtj8sLWbCDLVsyIZP\n"
"FHQBaquCSc6pb5Drv34ZtU2h1P/A6G7K+nabCMqWRnOLgxCqgpOUwQuLELgrpD1e\n"
"MmfxGvUvrd+H26VPVDipn/3s/QewmxMJfNEPxa0W0c95DGGYZHWIlJVT8kfm5enF\n"
"nHO4eLIZAgMBAAGjYzBhMB0GA1UdDgQWBBTxfe1boMtR7DwIS6ZYMiLSnT1u6jAf\n"
"BgNVHSMEGDAWgBTxfe1boMtR7DwIS6ZYMiLSnT1u6jAPBgNVHRMBAf8EBTADAQH/\n"
"MA4GA1UdDwEB/wQEAwIBhjANBgkqhkiG9w0BAQsFAAOCAQEAZDpUZAUi87PqR+Bv\n"
"xAIISXSYMk2zVsAhOVXnjS2b3/nDwFWnrrMcv2pqLI8cciwPpgCBbJ/yz2PZD8Wc\n"
"sWyijWgbKoHLQIS+U8Vbk4DghByuHZaJVWwUhlzwO044mFUXX9/2Fkpin7aE8qZV\n"
"HNFB8z8MufKTelmxpJZtSJK+aQNMTVsgEbepo88ZAYiw/LZxiBUrEhK+DXa3Os8B\n"
"bFpAqI55r74VuSwTApuRlJr8Zc8ftAI6+eM7lzZiSSJtnzSvy3cswQ2271C2B9Y+\n"
"kICQ8vhMIJZYlcUaKLIkNZRkf51VWgjpe6LiulHOqjTyOZYgk10gYfPMErC3GyL+\n"
"JEK4Aw==\n"
"-----END CERTIFICATE-----\n";

const char g_pTestRvkIntermediateCa[] =
"-----BEGIN CERTIFICATE-----\n"
"MIIDgzCCAmugAwIBAgIDM+FAMA0GCSqGSIb3DQEBCwUAMFUxCzAJBgNVBAYTAlVT\n"
"MQswCQYDVQQIDAJXQTEQMA4GA1UEBwwHUmVkbW9uZDEMMAoGA1UECgwDTlREMRkw\n"
"FwYDVQQDDBByb290Lm5hdGZfMzQuY29tMB4XDTE3MDgyMzIwNTgzNloXDTI3MDgy\n"
"MTIwNTgzNlowSzELMAkGA1UEBhMCVVMxCzAJBgNVBAgMAldBMQwwCgYDVQQKDANO\n"
"VEQxITAfBgNVBAMMGGludGVybWVkaWF0ZS5uYXRmXzM0LmNvbTCCASIwDQYJKoZI\n"
"hvcNAQEBBQADggEPADCCAQoCggEBAKp1ImebzRAa9205qxuttgSJj+lNDHwuWdgt\n"
"dHhRjSUN8OcmfS8Xcc5pr6Fx4oZq2ybYbA63O4xslosey77g/DJBeuAmApF+C3Om\n"
"+75yIA1DikAcBEzis7in6cGaH47IJoF56ShZAL/hrAro+rKG45M3GqWuQo7E7nTr\n"
"r6aoHljQBUVu8IWU5pCr7Icb7joY8hNo3d/33RhG/mBksDdatKQriAzJJW5YG6ka\n"
"S1n6Gs2OVDfIeGPTlEW7h/LmSpZy19aFg5loYLFGZ7FN2DBSaWPtUqRUlJN0wMAv\n"
"GLrGMtHgHx7TqlRtn9RmcZ2RV7P0LBwVPKkFqSxu6jAVAeqtLBsCAwEAAaNmMGQw\n"
"HQYDVR0OBBYEFL8hMw9sprZ25AnW65dSFcknZIFMMB8GA1UdIwQYMBaAFPF97Vug\n"
"y1HsPAhLplgyItKdPW7qMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQD\n"
"AgGGMA0GCSqGSIb3DQEBCwUAA4IBAQBPmWD7SXnaHJBjvr+H6QQpmlQKJXAy/HOM\n"
"enBGn8dj58oCzTYOac0GwdjunMePHhUUjNjLRXs84M2pmWIcZh7ZyIjowm1ZiO4j\n"
"ziydC2zfIb+fpM5DQw8tUa9M0PwBGJXB+HE9xDWp17wKGcwXKvJbjm+PGUeYSmVX\n"
"cthiD/iBXGW6msJNqJ3lCWyICok58pm9kMPllu+Elud9O+P6Q9gAgDn5/cLpkfVV\n"
"YXVzoAlBfy9meBlGPTifIgIeYyiXTK/xhu/qIF3n7hRIOXoOBAfMq4LEDsyinF1b\n"
"RjfEeiGB33hjxA5CkV9CpBpSm/ryV0mZPyYQ2aGGgn/Bw5W3I7MT\n"
"-----END CERTIFICATE-----\n";


const uint8_t g_pTestCrlRvkServer[] =
{
    0x30, 0x82, 0x01, 0xBC, 0x30, 0x81, 0xA5, 0x02, 0x01, 0x01, 0x30, 0x0D, 0x06,
    0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x0B, 0x05, 0x00, 0x30,
    0x4B, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55,
    0x53, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x08, 0x0C, 0x02, 0x57,
    0x41, 0x31, 0x0C, 0x30, 0x0A, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x0C, 0x03, 0x4E,
    0x54, 0x44, 0x31, 0x21, 0x30, 0x1F, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0C, 0x18,
    0x69, 0x6E, 0x74, 0x65, 0x72, 0x6D, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x2E,
    0x6E, 0x61, 0x74, 0x66, 0x5F, 0x33, 0x34, 0x2E, 0x63, 0x6F, 0x6D, 0x17, 0x0D,
    0x31, 0x37, 0x30, 0x38, 0x32, 0x34, 0x31, 0x36, 0x32, 0x34, 0x34, 0x30, 0x5A,
    0x17, 0x0D, 0x32, 0x37, 0x30, 0x38, 0x32, 0x32, 0x31, 0x36, 0x32, 0x34, 0x34,
    0x30, 0x5A, 0x30, 0x16, 0x30, 0x14, 0x02, 0x03, 0x33, 0xE5, 0x28, 0x17, 0x0D,
    0x31, 0x37, 0x30, 0x38, 0x32, 0x34, 0x31, 0x36, 0x32, 0x33, 0x34, 0x31, 0x5A,
    0xA0, 0x0E, 0x30, 0x0C, 0x30, 0x0A, 0x06, 0x03, 0x55, 0x1D, 0x14, 0x04, 0x03,
    0x02, 0x01, 0x01, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D,
    0x01, 0x01, 0x0B, 0x05, 0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0x8B, 0x71, 0xC1,
    0x3C, 0x78, 0x66, 0xC0, 0x79, 0xC3, 0x83, 0x39, 0x39, 0xB3, 0xDC, 0x77, 0xB8,
    0x94, 0xCD, 0xC4, 0x74, 0x7F, 0x21, 0x26, 0x69, 0x8E, 0x00, 0xFC, 0x98, 0x76,
    0x35, 0xEA, 0x89, 0xA3, 0x63, 0xA7, 0x84, 0x62, 0x8C, 0x80, 0xCE, 0x1E, 0xCC,
    0x2C, 0x2E, 0xEB, 0x13, 0x5C, 0x7F, 0x4E, 0xC1, 0x05, 0x79, 0x1F, 0x62, 0x8B,
    0x23, 0x82, 0x5A, 0x27, 0x0E, 0x7C, 0xE2, 0xF0, 0x30, 0x98, 0x30, 0x74, 0xEA,
    0x09, 0x7E, 0x2E, 0x34, 0x9C, 0x80, 0x2A, 0x0B, 0xF8, 0x68, 0x8A, 0x9D, 0x8C,
    0xB1, 0xAD, 0x2E, 0xDE, 0x50, 0x74, 0xCC, 0x41, 0x1C, 0x59, 0x3E, 0x45, 0x0A,
    0xC9, 0x18, 0x46, 0x8E, 0x15, 0x3A, 0xAD, 0x1D, 0xED, 0x87, 0x3E, 0x58, 0x6F,
    0x1D, 0x86, 0x08, 0x05, 0xA7, 0xB8, 0x4B, 0xA6, 0x71, 0x87, 0x03, 0x08, 0xED,
    0x69, 0x71, 0x4A, 0xC0, 0x9D, 0x41, 0x2D, 0x91, 0x94, 0x56, 0x0B, 0x8C, 0xF9,
    0xD1, 0xF3, 0x29, 0x5F, 0x11, 0xB1, 0x41, 0xA4, 0x72, 0x69, 0xD5, 0x9D, 0xB8,
    0xAE, 0xEC, 0x31, 0xD6, 0x77, 0xCB, 0x0C, 0x51, 0x4D, 0x1D, 0x68, 0x94, 0x62,
    0x2D, 0x3F, 0xD1, 0x06, 0x31, 0x96, 0xB9, 0xE5, 0xC6, 0xBC, 0xFE, 0x6C, 0x63,
    0x67, 0xDF, 0x72, 0xDA, 0x04, 0x40, 0x73, 0x9C, 0xEB, 0x0E, 0xC6, 0xB6, 0xF9,
    0x2D, 0x05, 0x9A, 0xD4, 0xFC, 0x18, 0x53, 0x5E, 0x33, 0xB0, 0xEC, 0x1E, 0xCE,
    0x30, 0xD4, 0xAA, 0x3D, 0x2F, 0xCE, 0x48, 0x11, 0x39, 0xA0, 0xF9, 0x1C, 0x9C,
    0x4E, 0x48, 0x8E, 0xE3, 0x62, 0x6E, 0x9C, 0xAF, 0x44, 0xAD, 0x93, 0x33, 0x57,
    0x62, 0x0D, 0xE6, 0x56, 0xB6, 0x05, 0x26, 0x76, 0xDA, 0x59, 0x90, 0x50, 0xA6,
    0xFA, 0xA1, 0x90, 0x9D, 0x72, 0x67, 0x0F, 0x77, 0x16, 0x5F, 0xA9, 0xC9, 0x0A,
    0xD4, 0x81, 0x49, 0x45, 0x06, 0xF3
};


const uint8_t g_pTestCrlRvkIntermediateCa[] =
{
    0x30, 0x82, 0x01, 0xC6, 0x30, 0x81, 0xAF, 0x02, 0x01, 0x01, 0x30, 0x0D, 0x06,
    0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x0B, 0x05, 0x00, 0x30,
    0x55, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55,
    0x53, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x08, 0x0C, 0x02, 0x57,
    0x41, 0x31, 0x10, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x04, 0x07, 0x0C, 0x07, 0x52,
    0x65, 0x64, 0x6D, 0x6F, 0x6E, 0x64, 0x31, 0x0C, 0x30, 0x0A, 0x06, 0x03, 0x55,
    0x04, 0x0A, 0x0C, 0x03, 0x4E, 0x54, 0x44, 0x31, 0x19, 0x30, 0x17, 0x06, 0x03,
    0x55, 0x04, 0x03, 0x0C, 0x10, 0x72, 0x6F, 0x6F, 0x74, 0x2E, 0x6E, 0x61, 0x74,
    0x66, 0x5F, 0x33, 0x34, 0x2E, 0x63, 0x6F, 0x6D, 0x17, 0x0D, 0x31, 0x37, 0x30,
    0x38, 0x32, 0x34, 0x31, 0x36, 0x34, 0x31, 0x30, 0x38, 0x5A, 0x17, 0x0D, 0x32,
    0x37, 0x30, 0x38, 0x32, 0x32, 0x31, 0x36, 0x34, 0x31, 0x30, 0x38, 0x5A, 0x30,
    0x16, 0x30, 0x14, 0x02, 0x03, 0x33, 0xE1, 0x40, 0x17, 0x0D, 0x31, 0x37, 0x30,
    0x38, 0x32, 0x33, 0x32, 0x30, 0x35, 0x38, 0x33, 0x37, 0x5A, 0xA0, 0x0E, 0x30,
    0x0C, 0x30, 0x0A, 0x06, 0x03, 0x55, 0x1D, 0x14, 0x04, 0x03, 0x02, 0x01, 0x01,
    0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x0B,
    0x05, 0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0x58, 0xBF, 0x0E, 0xFD, 0x3F, 0x86,
    0xC2, 0xB2, 0x1B, 0x8F, 0x2F, 0x30, 0x68, 0xF0, 0x6C, 0xE3, 0xA2, 0xD6, 0x9E,
    0xEE, 0x3D, 0x4A, 0xA1, 0x83, 0xB9, 0x56, 0x54, 0x5E, 0xFE, 0x61, 0x97, 0x65,
    0xC8, 0x0D, 0x1C, 0x79, 0x37, 0xAE, 0xC0, 0x56, 0xF0, 0x1C, 0x4B, 0xBC, 0x2D,
    0x10, 0x4A, 0xE1, 0x8A, 0x82, 0x4C, 0xA7, 0xB2, 0x71, 0x66, 0xF2, 0xC3, 0x6F,
    0xF6, 0xC0, 0x4F, 0x9C, 0xB7, 0xC4, 0xBF, 0x55, 0xD2, 0x44, 0x90, 0x6F, 0x72,
    0x8E, 0x5C, 0xE6, 0xAB, 0x9F, 0x4F, 0xD1, 0xEB, 0x88, 0x27, 0x53, 0x73, 0x5B,
    0xD5, 0xD1, 0x35, 0xA7, 0x6B, 0x14, 0xB9, 0x1D, 0x3F, 0xA0, 0x4C, 0xBA, 0xAC,
    0x3D, 0x98, 0xA5, 0xE0, 0x24, 0xF9, 0xB3, 0x4B, 0xD8, 0x65, 0x6F, 0xE3, 0x6F,
    0xB8, 0xBB, 0x17, 0xC3, 0x8B, 0x93, 0xCC, 0xBE, 0x98, 0x31, 0xDA, 0xD0, 0x48,
    0x4B, 0x61, 0x05, 0x11, 0x33, 0xCD, 0x0C, 0x3D, 0xEC, 0x16, 0xB7, 0xA0, 0x99,
    0x45, 0x77, 0x90, 0x1F, 0x3E, 0xAC, 0x73, 0xA2, 0xFE, 0xED, 0x67, 0x82, 0x8F,
    0x81, 0x66, 0x52, 0xD6, 0xCB, 0xB9, 0x1A, 0x97, 0x64, 0x97, 0xB4, 0x38, 0x9E,
    0x06, 0x63, 0xCB, 0x8C, 0x32, 0x97, 0x5F, 0xB9, 0xE6, 0xB6, 0x83, 0x4B, 0x2F,
    0x1C, 0xA2, 0xD4, 0xDB, 0x6B, 0xD2, 0xB4, 0x7E, 0xDF, 0x8B, 0xE7, 0xCC, 0x0B,
    0x6D, 0x74, 0x4C, 0x2E, 0x4A, 0x49, 0x13, 0xA7, 0xB3, 0x83, 0x21, 0x80, 0x13,
    0x29, 0xE2, 0xA2, 0x3B, 0xDC, 0xBD, 0x6F, 0x55, 0x97, 0xFA, 0xD5, 0xE5, 0xC5,
    0xE9, 0x6D, 0x99, 0x75, 0xDF, 0xDC, 0x9B, 0x6C, 0xFC, 0xB8, 0x7E, 0xC3, 0x60,
    0xF1, 0xC4, 0x69, 0x10, 0x0B, 0x73, 0xBA, 0x73, 0x79, 0x85, 0x1C, 0x34, 0xFE,
    0xDA, 0x4F, 0x16, 0x02, 0xFC, 0xBC, 0xC1, 0x17, 0xC9, 0x7E, 0xFC, 0x19, 0x18,
    0x50, 0x60, 0x08
};


const uint8_t g_pTestCrlRvkIntermediateCaBadSig[] =
{
    0x30, 0x82, 0x01, 0xBC, 0x30, 0x81, 0xA5, 0x02, 0x01, 0x01, 0x30, 0x0D, 0x06,
    0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x0B, 0x05, 0x00, 0x30,
    0x4B, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55,
    0x53, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x08, 0x0C, 0x02, 0x57,
    0x41, 0x31, 0x0C, 0x30, 0x0A, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x0C, 0x03, 0x4E,
    0x54, 0x44, 0x31, 0x21, 0x30, 0x1F, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0C, 0x18,
    0x69, 0x6E, 0x74, 0x65, 0x72, 0x6D, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x2E,
    0x6E, 0x61, 0x74, 0x66, 0x5F, 0x33, 0x34, 0x2E, 0x63, 0x6F, 0x6D, 0x17, 0x0D,
    0x31, 0x37, 0x30, 0x38, 0x32, 0x33, 0x32, 0x30, 0x35, 0x38, 0x33, 0x38, 0x5A,
    0x17, 0x0D, 0x32, 0x37, 0x30, 0x38, 0x32, 0x31, 0x32, 0x30, 0x35, 0x38, 0x33,
    0x38, 0x5A, 0x30, 0x16, 0x30, 0x14, 0x02, 0x03, 0x33, 0xE5, 0x28, 0x17, 0x0D,
    0x31, 0x37, 0x30, 0x38, 0x32, 0x33, 0x32, 0x30, 0x35, 0x38, 0x33, 0x37, 0x5A,
    0xA0, 0x0E, 0x30, 0x0C, 0x30, 0x0A, 0x06, 0x03, 0x55, 0x1D, 0x14, 0x04, 0x03,
    0x02, 0x01, 0x01, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D,
    0x01, 0x01, 0x0B, 0x05, 0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0x71, 0x48, 0x5E,
    0xCD, 0x97, 0x7A, 0xE9, 0x08, 0xCF, 0x92, 0x21, 0x60, 0xAF, 0x68, 0x65, 0x1B,
    0x64, 0xD6, 0xE1, 0xF4, 0x4F, 0x3D, 0x9D, 0x53, 0x61, 0xA9, 0x19, 0xA5, 0x2E,
    0xCD, 0x63, 0x72, 0x10, 0x71, 0xFB, 0x62, 0x64, 0x25, 0x27, 0xE2, 0xAA, 0x67,
    0xD3, 0x2D, 0x44, 0x08, 0x6B, 0x10, 0x0D, 0x11, 0xF4, 0x54, 0x40, 0xF5, 0x09,
    0x78, 0x46, 0x4B, 0x47, 0x04, 0x21, 0x93, 0x46, 0x54, 0xB4, 0x95, 0xEB, 0x7E,
    0xC7, 0xEA, 0x34, 0x1B, 0x4E, 0x08, 0xCD, 0x28, 0x56, 0x99, 0xB4, 0xAF, 0x98,
    0x3D, 0x99, 0x5B, 0x42, 0x9B, 0xAC, 0x0F, 0x1A, 0x31, 0xFD, 0x0C, 0x16, 0xF7,
    0xBD, 0xA5, 0xB4, 0xB5, 0x21, 0x2B, 0x83, 0x92, 0x8C, 0x08, 0x4B, 0x43, 0x05,
    0xE6, 0x7E, 0x61, 0xC9, 0xE6, 0xF6, 0x20, 0x11, 0x1C, 0xB0, 0x75, 0x57, 0xE3,
    0xF1, 0xAD, 0x8C, 0x3F, 0x69, 0x02, 0x2B, 0x4F, 0xC8, 0x7D, 0xAF, 0x54, 0xAF,
    0x03, 0xA2, 0x91, 0x16, 0xE8, 0xD8, 0x38, 0x0D, 0x07, 0x41, 0x45, 0x00, 0xCD,
    0xFD, 0xF7, 0xAB, 0x45, 0x9F, 0xD7, 0x29, 0x43, 0x20, 0x0B, 0x60, 0x25, 0x6F,
    0xC2, 0x14, 0xF4, 0x82, 0x72, 0xCA, 0xF5, 0xEF, 0xC8, 0x7F, 0x95, 0x0A, 0x5A,
    0x80, 0x26, 0x5F, 0xD0, 0xFF, 0x2D, 0x93, 0x99, 0x15, 0x54, 0x3E, 0xA1, 0x1D,
    0xFB, 0x80, 0xB5, 0x81, 0xA8, 0xA3, 0x13, 0x96, 0xC7, 0x59, 0xB6, 0xB3, 0xD1,
    0x99, 0x1C, 0x15, 0x12, 0x1B, 0x41, 0x22, 0x8B, 0x8B, 0xA4, 0x6F, 0xE3, 0xCA,
    0x2F, 0x4C, 0xE6, 0xAF, 0xE4, 0xDC, 0x97, 0xF1, 0xA5, 0xBA, 0x40, 0x2A, 0x64,
    0xB8, 0xED, 0x46, 0x28, 0x56, 0x34, 0xE6, 0xA8, 0xBA, 0xAB, 0x94, 0xF2, 0x08,
    0x16, 0xD2, 0x5A, 0x9D, 0x21, 0x75, 0x8D, 0x0A, 0x22, 0x96, 0x89, 0xF6, 0x34,
    0x5C, 0x87, 0xDD, 0x30, 0x9F, 0xB0
};
