﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/os/os_Macro.h>
#include <nn/init.h>
#include <nn/nn_Log.h>

#include <nn/nifm.h>
#include <nn/ssl.h>
#include <nnc/ssl/ssl_Context.h>
#include <nnc/ssl/ssl_Connection.h>

NN_OS_EXTERN_C bool CheckAndDumpNnSslClassSize()
{
    nn::ssl::Context sslContext;
    nn::ssl::Connection sslConnection;

    NN_LOG("Dump class size ------------------------------------\n");
    NN_LOG("nn::ssl::Context = %d (objSize:%d)\n", sizeof(nn::ssl::Context), sizeof(sslContext));
    NN_LOG("nn::ssl::Connection = %d (objSize:%d)\n", sizeof(nn::ssl::Connection), sizeof(sslConnection));
    NN_LOG("----------------------------------------------------\n");

    bool isValid = true;
    if(sizeof(nnsslSslContextType) < sizeof(nn::ssl::Context))
    {
        NN_LOG("The size of nnsslSslContextType is insufficient (%d, but needs to be larger than %d)",
            sizeof(nnsslSslContextType), sizeof(nn::ssl::Context));
        isValid = false;
    }
    if(sizeof(nnsslSslConnectionType) < sizeof(nn::ssl::Connection))
    {
        NN_LOG("The size of nnsslSslConnectionType is insufficient (%d, but needs to be larger than %d)",
            sizeof(nnsslSslConnectionType), sizeof(nn::ssl::Connection));
        isValid = false;
    }

    NN_LOG("Size check: %s\n", (isValid)?("PASS"):("FAILED"));
    return isValid;
}

NN_OS_EXTERN_C void UtilLog(char* str)
{
    NN_LOG("%s", str);
}

