﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------*
  Test code for Performance logger
 *---------------------------------------------------------------------------*/

#include <nn/perflog/PerfLogger.h>
#include <nn/perflog/DumpThread.h>
#include <nnt/nntest.h>
#include <nn/nn_Log.h>


using namespace nn::perflog;

namespace
{
    const int maxNumLogEntries = 2048;
    typedef uint64_t LogContext;
    typedef nn::perflog::PerfLogger< LogContext, maxNumLogEntries> DumpTestLoggerType;

    int g_CallbackCallCounter = 0;
    void* g_FilterCapture = NULL;
}









static void boo(void *pFilter)
{
    g_CallbackCallCounter++;
    g_FilterCapture = pFilter;
}


TEST(DumpThreadTest, basicC)
{
    OSEvent e;
    g_CallbackCallCounter = 0;
    g_FilterCapture = NULL;
    DumpThread<decltype(&boo)>  dthread1(&boo, (void *)0xfff5 ); // requires C++11 !!!

    EXPECT_EQ( dthread1.Start(&e), true );
    nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(100));

    EXPECT_EQ( g_CallbackCallCounter, 0 ); // no calls yet

    OSSignalEvent( &e );
    while( g_CallbackCallCounter == 0 )
    {
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(10));
    }

    EXPECT_EQ( g_CallbackCallCounter, 1 ); // 1 call expected
    EXPECT_EQ( g_FilterCapture, (void *)0xfff5 ); // value expected

    dthread1.Stop();

    nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(100));
    EXPECT_EQ( g_CallbackCallCounter, 1 ); // 1 call expected
    EXPECT_EQ( g_FilterCapture, (void *)0xfff5 ); // 1 call expected
}

