﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/init.h>
#include <nn/socket/socket_Api.h>
#include <nn/socket/socket_Types.h>
#include <nn/nn_Assert.h>
#include <nnt.h>
#include <nn/nn_Log.h>

extern "C" void nninitStartup()
{    // メモリヒープの全体サイズを設定する
    const size_t MemoryHeapSize = 32 * 1024 * 1024;

    // Temp work around for race condition bug (disabled by default)
    //NN_LOG("nn::os::SleepThread: In\n");
    //nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(2000) );
    //NN_LOG("nn::os::SleepThread: Out\n");

    NN_LOG("nninitStartup: In\n");
    auto result = nn::os::SetMemoryHeapSize( MemoryHeapSize + nn::socket::DefaultSocketMemoryPoolSize );

    NN_ASSERT( result.IsSuccess() );

    // メモリヒープから malloc で使用するメモリ領域を確保
    uintptr_t address = 0;

    result = nn::os::AllocateMemoryBlock( &address, MemoryHeapSize );
    NN_ASSERT( result.IsSuccess() );

    // malloc 用のメモリ領域を設定する
    nn::init::InitializeAllocator( reinterpret_cast<void*>(address), MemoryHeapSize );
    NN_LOG("IninitStartup: Out\n");
}
