﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//////////////////////////////////////////////////////////////
// DEFAULT: ENABLE_FAILING_TESTS - DISABLED
//
// #define ENABLE_FAILING_TESTS

#include "testNet_ApiCommon.h"
#include "Unit/testNet_ApiUnitCommon.h"

#include <cstdio>     // sprintf
#include <cctype>     // isprint
#include <cstdlib>    // malloc
#include <cmath>      // abs

#include <nn/os.h>
#include <nn/nn_Log.h>

#include <nn/socket.h>
#include <nn/socket/socket_ApiPrivate.h>

#include <nnt/nntest.h>

#include <nn/os/os_Thread.h>

#include <nn/nifm/nifm_Api.h>
#include <nn/nifm/nifm_ApiIpAddress.h>          // nn::nifm::GetCurrentIpConfigInfo
#include <nn/nifm.h>

#include "Unit/testNet_CommonFunctions.h"       // Common Functions

namespace NATF {
namespace API {

//////////////////////////////////////////////////////////////
//
// I M P O R T A N T:  This testing is *ONLY* for NX.  These tests do not work on Windows
//
//////////////////////////////////////////////////////////////

#ifndef NN_BUILD_CONFIG_OS_WIN32

//*********************
//*  G L O B A L S
//*********************


static bool
InitializeTesting()
{
    bool        isSuccess = true;

    NN_LOG( "In\n\n" );

    ///////////////////////////
    //// Test Counts: Initialize
    ///////////////////////////

    INITIALIZE_TEST_COUNTS;


    ///////////////////////////
    //// NIFM Library: Initialize
    ///////////////////////////

    ERROR_IF(!NATF::API::TestSetup(NATF::API::TestSetupOptions_Nifm | NATF::API::TestSetupOptions_Socket), "TestSetup failed.");

    // NIFM: Network Interface is Online
    NN_LOG( "====================================\n" );
    NN_LOG( "NIFM: Network ===>  O N L I N E <===\n" );
    NN_LOG( "====================================\n" );


    return( true );

out:

    return( false );
}


static bool
TeardownTesting()
{
     bool    isSuccess = true;

    ////////////////////
    ////  Stop Testing
    ////////////////////

    ERROR_IF(!NATF::API::TestTeardown(), "TestTeardown failed.");

    ////////////////////
    ////  Print Test Counts
    ////////////////////

    PRINT_TEST_COUNTS;

    EXPECT_EQ( isSuccess, true );

    NN_LOG( "Out\n\n" );

    return( true );

out:

    return( false );
}



////////////////
//
// B E G I N   T E S T I N G
//
////////////////

TEST(ApiUnit,SockAtMark_Initialize)
{
    InitializeTesting();
}


TEST(ApiUnit,SockAtMark_Various_Tests)
{
    int                 idx = 0, rc = 0, outAddrLen = 0;
    nn::socket::Errno   myError = nn::socket::Errno::ESuccess;

    ////////////
    // Test nn::socket::Errno::EBadf
    ///////////
    NN_LOG( "Testing for nn::socket::Errno::EBadf on SockAtMark\n\n" );

    NN_LOG( "Testing descriptor:" );
    for ( idx = -2; idx < 40; idx++ )
    {
        NN_LOG( "%d, ", idx );

        outAddrLen = sizeof( nn::socket::SockAddr );
        rc = nn::socket::SockAtMark( idx );
        if ( rc > 0 )
        {
            NN_LOG( "\nSend() succeeded but should have failed processing descriptor: %d\n", idx );
            goto out;
        }

        if ( rc < 0 )
        {
            myError = nn::socket::GetLastError();
            if ( myError != nn::socket::Errno::EBadf )
            {
                NN_LOG( "\nSend() bad fds: %d should have failed with nn::socket::Errno::EBadf, but actually failed with: %d\n", idx, myError );
                goto out;
            }

            continue;  // Jump to top
        }

        if ( rc == 0 )
        {
            NN_LOG( "\nSend() fds: %d:  Succeeded but sent (no bytes)!\n", idx );
            goto out;
        }
    }

out:

    NN_LOG( "\n" );


}


TEST( ApiUnit,SockAtMark_SO_OOB)
{

    int                     cliSock = -1, listenSock = -1, acceptedSock = -1;
    int                     rc = -1;
    bool                    isSuccess = true, isOOB = false;
    int                     disableFlag = 0, count = 0, atMark = 0;
    nn::socket::Errno       myError = nn::socket::Errno::ESuccess;
    nn::socket::SockLenT    optlen = sizeof( disableFlag );
    char                    buf1[1024];

    const char * msgs[]
    {
         "The rain in Spain...",
         "Flows",
         " mainly on the plain.",
         "The rain in Spain...Flows mainly on the plain."
    };

    ////////////////
    // Create Server
    ////////////////

    rc = NATF::API::COMMON::MakeListenSocket( listenSock, 9001, "127.0.0.1" );
    ERROR_IF_AND_COUNT( listenSock < 0, "Failed to creat Server socket\n" );
    NN_LOG( "[TCP] Server established at: loopback:9001\n" );


    ////////////////
    // Create Client
    ////////////////

    cliSock = NATF::API::COMMON::MakeTCPConnection( "127.0.0.1", 9001 );
    ERROR_IF_AND_COUNT( cliSock < 0, "Failed to create Server socket\n" );
    NN_LOG( "[TCP] Client connected to: loopback:9001\n" );


    ////////////////
    // Server Accepts New Client
    ////////////////

    acceptedSock = nn::socket::Accept( listenSock, static_cast<nn::socket::SockAddr*>(nullptr), 0 );
    ERROR_IF_AND_COUNT( acceptedSock < 0, "Failed calling Accept on Listen Socket - Errno: %d\n", nn::socket::GetLastError() );


    ////////////////
    // Server Turns off OOBINLINE
    ////////////////

    rc = nn::socket::SetSockOpt( acceptedSock, nn::socket::Level::Sol_Socket, nn::socket::Option::So_OobInline,(void *) &disableFlag, optlen );
    ERROR_IF( rc < 0, "SetSockOpt() failed for nn::socket::Option::So_OobInline - Errno: %d\n", nn::socket::GetLastError() );


    ////////////////
    // Server turns on NON-BLOCKING
    ////////////////

    rc = nn::socket::Fcntl( acceptedSock, nn::socket::FcntlCommand::F_SetFl, nn::socket::FcntlFlag::O_NonBlock );
    ERROR_IF( rc < 0, "Fcntl() failed for nn::socket::FcntlFlag::O_NonBlock - Errno: %d\n", nn::socket::GetLastError() );


    //////////////
    // Client Writes (regular) and (OOB) data to server..
    //////////////

    NN_LOG( "Send(): %.*s\n", strlen( msgs[0] ), msgs[0] );
    rc = nn::socket::Send( cliSock, (unsigned char *) msgs[0], strlen( msgs[0] ), nn::socket::MsgFlag::Msg_None );
    ERROR_IF_AND_COUNT( rc != strlen( msgs[0] ), "Client failed to write; %s\n", msgs[0] );

    NN_LOG( "Send() nn::socket::MsgFlag::Msg_Oob: %.*s\n", strlen( msgs[1] ), msgs[1] );
    rc = nn::socket::Send( cliSock, (unsigned char *) msgs[1], strlen( msgs[1] ), nn::socket::MsgFlag::Msg_Oob );
    ERROR_IF_AND_COUNT( rc != strlen( msgs[1] ), "Client failed to Send (OOB); %s\n", msgs[1] );

    NN_LOG( "Send(): %.*s\n", strlen( msgs[2] ), msgs[2] );
    rc = nn::socket::Send( cliSock, (unsigned char *) msgs[2], strlen( msgs[2] ), nn::socket::MsgFlag::Msg_None );
    ERROR_IF_AND_COUNT( rc != strlen( msgs[2] ), "Client failed to write; %s\n", msgs[2] );


    ///////////////
    // Server Reads (Regular) data BEFORE the OOB data (aka mark)
    ///////////////

    NN_LOG( "Read before Mark: [" );
    isOOB = false;
    for( ; ; )
    {
        atMark = nn::socket::SockAtMark( acceptedSock );
        if (atMark < 0 )
        {
            NN_LOG( "SockAtMark() failed - errno: %d\n", nn::socket::GetLastError() );
        }
        if ( atMark == 1 )
        {
            NN_LOG("[At Mark!]\n" );
            isOOB = true;
        }
        else
        {
            isOOB = false;
        }

        rc = nn::socket::Recv( acceptedSock, (unsigned char *) &buf1[count], 1, (isOOB == true ? nn::socket::MsgFlag::Msg_Oob : nn::socket::MsgFlag::Msg_None ) );
        if ( rc < 0 )
        {
            myError = nn::socket::GetLastError();

            // TRICKY: If nn::socket::Errno::EInval is returned it means "read again" without the OOB flag
            if ( myError == nn::socket::Errno::EInval )
            {
                rc = nn::socket::Recv( acceptedSock, (unsigned char *) &buf1[count], 1, nn::socket::MsgFlag::Msg_None );
                ERROR_IF( rc < 0, "Recv() failed without nn::socket::MsgFlag::Msg_Oob - Errno: %d\n", myError );
                NN_LOG( "%c", (char) buf1[count] );
                count++;
                continue;
            }
            // If it's not nn::socket::Errno::EInval then see if we are done reading
            if ( myError == nn::socket::Errno::EAgain || myError == nn::socket::Errno::EWouldBlock )
            {
                break;
            }

            NN_LOG( "Recv() failed with errno: %d\n", nn::socket::GetLastError() );
            goto out;
        }
        NN_LOG( "%c", (char) buf1[count] );
        count++;
        continue;
    }
    NN_LOG( "]\n" );

    printf( "Actual Received Data: [%.*s]\n", count, buf1 );

    // Validate returned data:
    if ( count == strlen( msgs[3] )  &&
         memcmp( msgs[3], buf1, count ) == 0 )
    {
        NN_LOG( "====================\n" );
        NN_LOG( "PASSED!  OOB and Normal Data returned correctly!\n" );
        NN_LOG( "====================\n" );
    }
    else
    {
        NN_LOG( "====================\n" );
        NN_LOG( "FAILED!  OOB Data [%.*s] and Actually Recieved Data [%.*s] do not match!\n",
                               count, buf1, strlen( msgs[3] ), msgs[3] );
        NN_LOG( "====================\n" );
    }


out:

    if ( cliSock > -1 )
    {
        nn::socket::Close( cliSock );
        cliSock = -1;
    }

    if ( acceptedSock > -1 )
    {
        nn::socket::Close( acceptedSock );
        acceptedSock = -1;
    }

    if ( listenSock > -1 )
    {
        nn::socket::Close( listenSock );
        listenSock = -1;
    }

}   // NOLINT(impl/function_size)


TEST( ApiUnit,SockAtMark_SO_OOBINLINE)
{

    int                     cliSock = -1, listenSock = -1, acceptedSock = -1;
    int                     rc = -1;
    bool                    isSuccess = true, isOOB = false;
    int                     enableFlag = 1, count = 0, atMark = 0;
    nn::socket::Errno       myError = nn::socket::Errno::ESuccess;
    nn::socket::SockLenT    optlen = sizeof( enableFlag );
    char                    buf1[1024];

    const char * msgs[]
    {
         "The rain in Spain...",
         "Flows",
         " mainly on the plain.",
         "The rain in Spain...Flows mainly on the plain."
    };

    ////////////////
    // Create Server
    ////////////////

    rc = NATF::API::COMMON::MakeListenSocket( listenSock, 9001, "127.0.0.1" );
    ERROR_IF_AND_COUNT( listenSock < 0, "Failed to creat Server socket\n" );
    NN_LOG( "[TCP] Server established at: loopback:9001\n" );


    ////////////////
    // Create Client
    ////////////////

    cliSock = NATF::API::COMMON::MakeTCPConnection( "127.0.0.1", 9001 );
    ERROR_IF_AND_COUNT( cliSock < 0, "Failed to create Server socket\n" );
    NN_LOG( "[TCP] Client connected to: loopback:9001\n" );


    ////////////////
    // Server Accepts New Client
    ////////////////

    acceptedSock = nn::socket::Accept( listenSock, static_cast<nn::socket::SockAddr*>(nullptr), 0 );
    ERROR_IF_AND_COUNT( acceptedSock < 0, "Failed calling Accept on Listen Socket - Errno: %d\n", nn::socket::GetLastError() );


    ////////////////
    // Server Turns ON OOBINLINE
    ////////////////

    rc = nn::socket::SetSockOpt( acceptedSock, nn::socket::Level::Sol_Socket, nn::socket::Option::So_OobInline,(void *) &enableFlag, optlen );
    ERROR_IF( rc < 0, "SetSockOpt() failed for nn::socket::Option::So_OobInline - Errno: %d\n", nn::socket::GetLastError() );


    ////////////////
    // Server turns ON NON-BLOCKING
    ////////////////

    rc = nn::socket::Fcntl( acceptedSock, nn::socket::FcntlCommand::F_SetFl, nn::socket::FcntlFlag::O_NonBlock );
    ERROR_IF( rc < 0, "Fcntl() failed for nn::socket::FcntlFlag::O_NonBlock - Errno: %d\n", nn::socket::GetLastError() );


    //////////////
    // Client Writes (regular) and (OOB) data to server..
    //////////////

    NN_LOG( "Send(): %.*s\n", strlen( msgs[0] ), msgs[0] );
    rc = nn::socket::Send( cliSock, (unsigned char *) msgs[0], strlen( msgs[0] ), nn::socket::MsgFlag::Msg_None );
    ERROR_IF_AND_COUNT( rc != strlen( msgs[0] ), "Client failed to write; %s\n", msgs[0] );

    NN_LOG( "Send() nn::socket::MsgFlag::Msg_Oob: %.*s\n", strlen( msgs[1] ), msgs[1] );
    rc = nn::socket::Send( cliSock, (unsigned char *) msgs[1], strlen( msgs[1] ), nn::socket::MsgFlag::Msg_Oob );
    ERROR_IF_AND_COUNT( rc != strlen( msgs[1] ), "Client failed to Send (OOB); %s\n", msgs[1] );

    NN_LOG( "Send(): %.*s\n", strlen( msgs[2] ), msgs[2] );
    rc = nn::socket::Send( cliSock, (unsigned char *) msgs[2], strlen( msgs[2] ), nn::socket::MsgFlag::Msg_None );
    ERROR_IF_AND_COUNT( rc != strlen( msgs[2] ), "Client failed to write; %s\n", msgs[2] );


    ///////////////
    // Server Reads (Regular) data BEFORE the OOB data (aka mark)
    ///////////////

    NN_LOG( "Read before Mark: [" );
    isOOB = false;
    for( ; ; )
    {
        atMark = nn::socket::SockAtMark( acceptedSock );
        if (atMark < 0 )
        {
            NN_LOG( "SockAtMark() failed - errno: %d\n", nn::socket::GetLastError() );
        }
        if ( atMark == 1 )
        {
            NN_LOG("[At Mark!]\n" );
            isOOB = true;
        }
        else
        {
            isOOB = false;
        }

        rc = nn::socket::Recv( acceptedSock, (unsigned char *) &buf1[count], 1, (isOOB == true ? nn::socket::MsgFlag::Msg_Oob : nn::socket::MsgFlag::Msg_None ) );
        if ( rc < 0 )
        {
            myError = nn::socket::GetLastError();

            // TRICKY: If nn::socket::Errno::EInval is returned it means "read again" without the OOB flag
            if ( myError == nn::socket::Errno::EInval )
            {
                rc = nn::socket::Recv( acceptedSock, (unsigned char *) &buf1[count], 1, nn::socket::MsgFlag::Msg_None );
                ERROR_IF( rc < 0, "Recv() failed without nn::socket::MsgFlag::Msg_Oob - Errno: %d\n", myError );
                NN_LOG( "%c", (char) buf1[count] );
                count++;
                continue;
            }
            // If it's not nn::socket::Errno::EInval then see if we are done reading
            if ( myError == nn::socket::Errno::EAgain || myError == nn::socket::Errno::EWouldBlock )
            {
                break;
            }

            NN_LOG( "Recv() failed with errno: %d\n", nn::socket::GetLastError() );
            goto out;
        }
        NN_LOG( "%c", (char) buf1[count] );
        count++;
        continue;
    }
    NN_LOG( "]\n" );

    printf( "Actual Received Data: [%.*s]\n", count, buf1 );

    // Validate returned data:
    if ( count == strlen( msgs[3] )  &&
         memcmp( msgs[3], buf1, count ) == 0 )
    {
        NN_LOG( "====================\n" );
        NN_LOG( "PASSED!  OOB and Normal Data returned correctly!\n" );
        NN_LOG( "====================\n" );
    }
    else
    {
        NN_LOG( "====================\n" );
        NN_LOG( "FAILED!  OOB Data [%.*s] and Actually Recieved Data [%.*s] do not match!\n",
                               count, buf1, strlen( msgs[3] ), msgs[3] );
        NN_LOG( "====================\n" );
    }


out:

    if ( cliSock > -1 )
    {
        nn::socket::Close( cliSock );
        cliSock = -1;
    }

    if ( acceptedSock > -1 )
    {
        nn::socket::Close( acceptedSock );
        acceptedSock = -1;
    }

    if ( listenSock > -1 )
    {
        nn::socket::Close( listenSock );
        listenSock = -1;
    }

}   // NOLINT(impl/function_size)

TEST( ApiUnit,SockAtMark_No_OOB_Data)
{
    int                 cliSock = -1, listenSock = -1, acceptedSock = -1;
    int                 rc = -1;
    bool                isSuccess = true;
    int                 count = 0, atMark = 0;
    nn::socket::Errno   myError = nn::socket::Errno::ESuccess;
    char                buf1[1024];

    const char * msgs[]
    {
         "The rain in Spain...",
         "Flows",
         " mainly on the plain.",
         "The rain in Spain...Flows mainly on the plain."
    };

    ////////////////
    // Create Server
    ////////////////

    rc = NATF::API::COMMON::MakeListenSocket( listenSock, 9001, "127.0.0.1" );
    ERROR_IF_AND_COUNT( listenSock < 0, "Failed to creat Server socket\n" );
    NN_LOG( "[TCP] Server established at: loopback:9001\n" );


    ////////////////
    // Create Client
    ////////////////

    cliSock = NATF::API::COMMON::MakeTCPConnection( "127.0.0.1", 9001 );
    ERROR_IF_AND_COUNT( cliSock < 0, "Failed to create Server socket\n" );
    NN_LOG( "[TCP] Client connected to: loopback:9001\n" );


    ////////////////
    // Server Accepts New Client
    ////////////////

    acceptedSock = nn::socket::Accept( listenSock, static_cast<nn::socket::SockAddr*>(nullptr), 0 );
    ERROR_IF_AND_COUNT( acceptedSock < 0, "Failed calling Accept on Listen Socket - Errno: %d\n", nn::socket::GetLastError() );


    ////////////////
    // Server turns ON NON-BLOCKING
    ////////////////

    rc = nn::socket::Fcntl( acceptedSock, nn::socket::FcntlCommand::F_SetFl, nn::socket::FcntlFlag::O_NonBlock );
    ERROR_IF( rc < 0, "Fcntl() failed for nn::socket::FcntlFlag::O_NonBlock - Errno: %d\n", nn::socket::GetLastError() );


    //////////////
    // Client Writes (regular) data to server..
    //////////////

    NN_LOG( "Send(): %.*s\n", strlen( msgs[0] ), msgs[0] );
    rc = nn::socket::Send( cliSock, (unsigned char *) msgs[0], strlen( msgs[0] ), nn::socket::MsgFlag::Msg_None );
    ERROR_IF_AND_COUNT( rc != strlen( msgs[0] ), "Client failed to Send: %s\n", msgs[0] );

    NN_LOG( "Send(): %.*s\n", strlen( msgs[1] ), msgs[1] );
    rc = nn::socket::Send( cliSock, (unsigned char *) msgs[1], strlen( msgs[1] ), nn::socket::MsgFlag::Msg_None );
    ERROR_IF_AND_COUNT( rc != strlen( msgs[1] ), "Client failed to Send: %s\n", msgs[1] );

    NN_LOG( "Send(): %.*s\n", strlen( msgs[2] ), msgs[2] );
    rc = nn::socket::Send( cliSock, (unsigned char *) msgs[2], strlen( msgs[2] ), nn::socket::MsgFlag::Msg_None );
    ERROR_IF_AND_COUNT( rc != strlen( msgs[2] ), "Client failed to Send: %s\n", msgs[2] );


    ///////////////
    // Server Reads only (Regular)
    ///////////////

    NN_LOG( "Read: [" );
    for( ; ; )
    {
        atMark = nn::socket::SockAtMark( acceptedSock );
        if (atMark < 0 )
        {
            NN_LOG( "SockAtMark() failed - errno: %d\n", nn::socket::GetLastError() );
        }
        if ( atMark == 1 )
        {
            NN_LOG("[At Mark!]\n" );
            ERROR_IF_AND_COUNT( atMark == 1, "SockAtMark() is 'AT MARK', but no out of band data was sent!" );
        }

        rc = nn::socket::Recv( acceptedSock, (unsigned char *) &buf1[count], 1, nn::socket::MsgFlag::Msg_None );
        if ( rc < 0 )
        {
            myError = nn::socket::GetLastError();

            // TRICKY: If nn::socket::Errno::EInval is returned it means "read again" without the OOB flag
            if ( myError == nn::socket::Errno::EInval )
            {
                rc = nn::socket::Recv( acceptedSock, (unsigned char *) &buf1[count], 1, nn::socket::MsgFlag::Msg_None );
                ERROR_IF( rc < 0, "Recv() failed without nn::socket::MsgFlag::Msg_Oob - Errno: %d\n", myError );
                NN_LOG( "%c", (char) buf1[count] );
                count++;
                continue;
            }
            // If it's not nn::socket::Errno::EInval then see if we are done reading
            if ( myError == nn::socket::Errno::EAgain || myError == nn::socket::Errno::EWouldBlock )
            {
                break;
            }

            NN_LOG( "Recv() failed with errno: %d\n", nn::socket::GetLastError() );
            goto out;
        }
        NN_LOG( "%c", (char) buf1[count] );
        count++;
        continue;
    }
    NN_LOG( "]\n" );

    printf( "Actual Received Data: [%.*s]\n", count, buf1 );

    // Validate returned data:
    if ( count == strlen( msgs[3] )  &&
         memcmp( msgs[3], buf1, count ) == 0 )
    {
        NN_LOG( "====================\n" );
        NN_LOG( "PASSED!  Normal Data returned correctly!\n" );
        NN_LOG( "====================\n" );
    }
    else
    {
        NN_LOG( "====================\n" );
        NN_LOG( "FAILED!  Normal Data [%.*s] and Actually Recieved Data [%.*s] do not match!\n",
                               count, buf1, strlen( msgs[3] ), msgs[3] );
        NN_LOG( "====================\n" );
    }

out:

    if ( cliSock > -1 )
    {
        nn::socket::Close( cliSock );
        cliSock = -1;
    }

    if ( acceptedSock > -1 )
    {
        nn::socket::Close( acceptedSock );
        acceptedSock = -1;
    }

    if ( listenSock > -1 )
    {
        nn::socket::Close( listenSock );
        listenSock = -1;
    }
}   // NOLINT(impl/function_size)

TEST(ApiUnit,SockAtMark_Teardown)
{
    TeardownTesting();
}

#else // Windows

TEST(ApiUnit,SockAtMark_Windows)
{
    NN_LOG( "=============================================\n" );
    NN_LOG( "===  N O   T E S T s   T O    R U N \n" );
    NN_LOG( "=============================================\n" );
}

#endif

}}  // Namespace: NATF::API
