﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Modules/SoTestDataXferModule.h"

namespace NATF {
namespace Tests {

    class TcpUdpNetwork : public BaseTest
    {
        NN_DISALLOW_COPY(TcpUdpNetwork);

    public:
        TcpUdpNetwork(const char* pTestName, const nn::util::Uuid& netProfile, uint32_t timeoutMs, const char* appTypeName, const char* ipAddr, uint32_t portNumber, const char* protocolTypeName, uint32_t durationSec, const char* xferPattern) NN_NOEXCEPT;
        virtual ~TcpUdpNetwork() NN_NOEXCEPT NN_OVERRIDE;

    private:
        virtual bool Cleanup() NN_NOEXCEPT NN_OVERRIDE;
        virtual bool Config() NN_NOEXCEPT NN_OVERRIDE;

        Modules::SoTestDataXfer* m_pNode;
        uint32_t m_timeoutMs;
        uint32_t m_portNumber;
        uint32_t m_durationSec;
        char m_appTypeName[Modules::SoTestDataXfer::MaxNameStringLen];
        char m_ipAddr[Modules::SoTestDataXfer::MaxIpAddrStringLen];
        char m_protocolTypeName[Modules::SoTestDataXfer::MaxNameStringLen];
        char* m_xferPattern;
    };

} // namespace Tests
} // namespace NATF
