﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/socket.h> // nn::socket::HostEnt

#include "testNet_ApiCommon.h"

////////////////////////////////////////////////////////////////
// DEFAULT: DISABLED

//#define ENABLE_FAILING_TESTS

#define LOG_FAILING_TEST(key, desc) \
do \
{ \
    NATF::API::BuildAndPrintJiraMessage(key, desc); \
} while( NN_STATIC_CONDITION(false) )

#ifdef ENABLE_FAILING_TESTS
    #define WRAP_FAILING_TEST(key, desc)  \
    LOG_FAILING_TEST(key, desc); \
    if( NN_STATIC_CONDITION(true) )
#else
    #define WRAP_FAILING_TEST(key, desc) \
    LOG_FAILING_TEST(key, desc); \
    ++NATF::API::nTestsSkipped; \
    if( NN_STATIC_CONDITION(false) )
#endif

#ifdef NN_BUILD_CONFIG_OS_WIN32
    #define WRAP_FAILING_TEST_WIN(key, desc) \
    WRAP_FAILING_TEST(key, desc)

    #define WRAP_FAILING_TEST_NX(key, desc) \
    do \
    { \
        \
    } while( NN_STATIC_CONDITION(false) );
#else
    #define WRAP_FAILING_TEST_WIN(key, desc) \
    do \
    { \
        \
    } while( NN_STATIC_CONDITION(false) );

    #define WRAP_FAILING_TEST_NX(key, desc) \
    WRAP_FAILING_TEST(key, desc)
#endif

#define ERROR_IF_AND_COUNT(condition, ...) \
do \
{ \
    if( condition ) \
    { \
        NN_LOG("\n\n * Error!");           \
        NN_LOG(" * File: %s\n", __FILE__); \
        NN_LOG(" * Function: %s, Line %d\n", __FUNCTION__, __LINE__); \
        NN_LOG(" * Errno: %d\n", nn::socket::GetLastError()); \
        NN_LOG(" * ");                     \
        NN_LOG(__VA_ARGS__);               \
        NN_LOG("\n\n");                    \
        isSuccess = false;                 \
        EXPECT_EQ(false, true);            \
        ++NATF::API::nTestsFailing;        \
        goto out;                          \
    } \
    else \
    { \
        ++NATF::API::nTestsPassing; \
    } \
} while( NN_STATIC_CONDITION(false) )

#define INITIALIZE_TEST_COUNTS \
do \
{ \
    NATF::API::nTestsPassing = 0; \
    NATF::API::nTestsFailing = 0; \
    NATF::API::nTestsSkipped = 0; \
} while( NN_STATIC_CONDITION(false) )

#define PRINT_TEST_COUNTS \
do \
{ \
    NN_LOG( "==============\n\n" ); \
    NN_LOG( "Tests Passed        : <%d>\n", NATF::API::nTestsPassing ); \
    NN_LOG( "Tests Failed        : <%d>\n", NATF::API::nTestsFailing ); \
    NN_LOG( "Tests Skipped       : <%d>\n", NATF::API::nTestsSkipped ); \
} while( NN_STATIC_CONDITION(false) )

#define SIZE_OF_ARRAY(a) sizeof(a)/sizeof((a)[0])

namespace NATF {
namespace API {

    enum
    {
        UrlCharValid_GenDelims = 0,
        UrlCharValid_SubDelims,
        UrlCharValid_Unreserved,
        UrlCharValid_NeedPctEncoding
    };

    extern const char *namesUrlCharValidStatesEnum[];

    extern int nTestsPassing;
    extern int nTestsFailing;
    extern int nTestsSkipped;

    bool ConvertToValidFormat(char *buffer, int len) NN_NOEXCEPT;
    bool BuildAndPrintJiraMessage(const char *name, const char *value) NN_NOEXCEPT;
    bool VerifyIpAddrEquiv(const char *addrAscii, const nn::socket::InAddr *pAddrNetwork) NN_NOEXCEPT;
    bool VerifyUrlCharValid(int *rval, char c) NN_NOEXCEPT;
    bool FindStrInList(bool *rval, const char** list, int listSize, const char *str) NN_NOEXCEPT;
    bool VerifyHostNetAddrEquiv(uint16_t hostAddr, uint16_t networkAddr) NN_NOEXCEPT;
    bool VerifyHostNetAddrEquiv(uint32_t hostAddr, uint32_t networkAddr) NN_NOEXCEPT;
    bool PrintSockaddrIn(nn::socket::SockAddrIn *pSockaddrIn) NN_NOEXCEPT;
    bool PrintHostent(nn::socket::HostEnt *pHostent) NN_NOEXCEPT;
    bool SetupSockaddrIn(nn::socket::SockAddrIn *pAddr, int16_t family, uint16_t portHostFormat, int addrHostFormat) NN_NOEXCEPT;
    bool SetupSockaddrIn(nn::socket::SockAddrIn *pAddr, int16_t family, uint16_t portHostFormat, const char *addrAsciiFormat) NN_NOEXCEPT;
    bool CloseAllSockets() NN_NOEXCEPT;

}} // NATF::API
