﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace NATF {
namespace API {

/**
 * @brief A reference count object interface
 */
class IReferenceCountObject
{
public:
    /** @brief add reference to this object */
    virtual int addReference() = 0;

    /** @brief release reference from this object */
    virtual int releaseReference() = 0;
};

/**
 * @brief a validator interface
 */
class IValidator
{
public:
    /** @brief return true for validate and false on failure */
    virtual bool DidSucceed() const = 0;

protected:
    /** @brief ctor */
    IValidator()
        ;
    /** @brief dtor */
    virtual ~IValidator();
};

class IUnitTestThread
{
public:
    /** @brief start the thread */
    virtual bool Start() = 0;

    /** @brief finish the thread */
    virtual bool Stop() = 0;

    enum State
    {
        STATE_INITIALIZED,
        STATE_STARTING,
        STATE_RUNNING,
        STATE_FINISHING,
        STATE_STOPPED,
        STATE_DESTROYED
    };

    /** @brief get the state of the thread */
    virtual State GetState() = 0;
};

/**
 * ITestManager is an empty interface to indicate that something IS-A test manager
 */
class ITestManager
{
public:
};

}} //NATF::API
