﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
 /*
 * Copyright 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/os.h>
#include <nn/fs.h>
#include <nn/init.h>
#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>

#define LOG_TAG "ScoopVideo"
#define ATRACE_TAG ATRACE_TAG_GRAPHICS
//#define LOG_NDEBUG 0

/*
long double strtold (const char *__restrict, char **__restrict);
_Noreturn void _Exit (int);
void *aligned_alloc( size_t alignment, size_t size );*/

#include <nn/lmem/lmem_ExpHeap.h>
#include <utils/Log.h>
#include <utils/Errors.h>
#include <utils/Timers.h>
#include <utils/Trace.h>
#include <gui/Surface.h>
#include <gui/SurfaceComposerClient.h>
#include <gui/ISurfaceComposer.h>
#include <ui/DisplayInfo.h>
#include <media/openmax/OMX_IVCommon.h>
#include <media/stagefright/foundation/ABuffer.h>
#include <media/stagefright/foundation/AMessage.h>
#include <media/stagefright/MediaCodec.h>
#include <media/stagefright/MediaErrors.h>
#include <media/stagefright/MediaMuxer.h>
#include <media/ICrypto.h>
#include <SfNvnUtil.h>
#include <OMX_Video.h>

#include <nn/nn_Log.h>

using namespace android;

static const char* kMimeTypeAvc = "video/avc";
static uint32_t gVideoWidth = 1280;        // default width+height
static uint32_t gVideoHeight = 720;
static uint32_t gBitRate = 2000000;     // 2Mbps
static uint32_t gFrameRate = 60;
static uint32_t gNumFrameRecord = 200;


sp<IGraphicBufferProducer> mProducer = NULL;
sp<MediaCodec> mEncoder;
sp<SurfaceComposerClient> mClient;
sp<IBinder> mDpy;
sp<IGraphicBufferConsumer> mConsumer;
buffer_handle_t mBuffers[2];
static const void *sRefBaseOwner;


#ifdef RAPTOR_ENHANCEMENT
extern void initializeLooperRoster();
extern void initializeAtomizer();
extern void initializeDataSource();
#endif

namespace{

    const int FsHeapSize = 512 * 1024;

    uint8_t              g_FsHeapBuffer[FsHeapSize];
    nn::lmem::HeapHandle g_FsHeap;

    void FsInitHeap()
    {
        g_FsHeap = nn::lmem::CreateExpHeap(g_FsHeapBuffer, FsHeapSize, nn::lmem::CreationOption_DebugFill);
    }

    void* FsAllocate(size_t size)
    {
        return nn::lmem::AllocateFromExpHeap(g_FsHeap, size);
    }

    void FsDeallocate(void* p, size_t size)
    {
        NN_UNUSED(size);
            return nn::lmem::FreeToExpHeap(g_FsHeap, p);
    }

}
extern "C" void nninitStartup()
{
    const size_t heapSize = 512 << 20;
    const size_t mallocSize = 32 << 20;
    uintptr_t address;
    nn::Result result;

    result = nn::os::SetMemoryHeapSize(heapSize);
    //ASSERT(result.IsSuccess());

    result = nn::os::AllocateMemoryBlock(&address, mallocSize);
    //ASSERT(result.IsSuccess());

    nn::init::InitializeAllocator(reinterpret_cast<void*>(address), mallocSize);
    FsInitHeap();
    nn::fs::SetAllocator(FsAllocate, FsDeallocate);
    NN_SDK_LOG("ninit done: \n");
}


sp<MediaCodec> prepareEncoder(){

    status_t err;
    sp<AMessage> format = new AMessage;

    format->setInt32("width", gVideoWidth);
    format->setInt32("height", gVideoHeight);
    format->setString("mime", kMimeTypeAvc);
    format->setInt32("encoder", true);
    format->setInt32("color-format", OMX_COLOR_FormatAndroidOpaque);
    //format->setInt32("color-format", OMX_COLOR_FormatYUV420Planar);
    format->setInt32("bitrate", gBitRate);
    format->setFloat("frame-rate", gFrameRate);
    format->setInt32("i-frame-interval", 10);
    //format->setInt32("prepend-sps-pps-to-idr-frames", 0);
    format->setInt32("profile", OMX_VIDEO_AVCProfileHigh);
    format->setInt32("level", OMX_VIDEO_AVCLevel41);
    ALOGV("New Loopern");
    sp<ALooper> looper = new ALooper;
    looper->setName("screenrecord_looper");
    looper->start();
    ALOGV("Creating codecn");
    sp<MediaCodec> mEncoder = MediaCodec::CreateByType(looper, kMimeTypeAvc, true);

    if (mEncoder == NULL) {
        ALOGV( "ERROR: unable to create %s codec instancen",
                kMimeTypeAvc);
        return mEncoder;
    }
    mEncoder->incStrong(&sRefBaseOwner);
    ALOGE("configuring");
    err = mEncoder->configure(format, NULL, NULL,
            MediaCodec::CONFIGURE_FLAG_ENCODE);
    if (err != NO_ERROR) {
        ALOGV( "ERROR: unable to configure %s codec at %dx%d (err=%d)n",
                kMimeTypeAvc, gVideoWidth, gVideoHeight, err);
        mEncoder->release();
        return mEncoder;
    }

    ALOGE("create encoder input surface");
    err = mEncoder->createInputSurface(&mProducer);
    if (err != NO_ERROR) {
        ALOGE("ERROR: unable to create encoder input surface (err=%d)n", err);
        mEncoder->release();
        return mEncoder;
    }
    ALOGE("Producer return from createInputSurface %p",mProducer.get());


    ALOGE("Starting codec");
    err = mEncoder->start();
    if (err != NO_ERROR) {
        ALOGV( "ERROR: unable to start codec (err=%d)n", err);
        mEncoder->release();
        return mEncoder;
    }
    ALOGE("Codec prepared");
    //mEncoder->incStrong(&sRefBaseOwner);
    return mEncoder;
}

static status_t runEncoder(const sp<MediaCodec>& encoder,
        const sp<MediaMuxer>& muxer/*, FILE* rawFp*/) {
    static int kTimeout = 250000;   // be responsive on signal
    status_t err;
    ssize_t trackIdx = -1;
    uint32_t nFrames = 0;

    ALOGE("runEncoder ");
    Vector<sp<ABuffer> > buffers;
    err = encoder->getOutputBuffers(&buffers);
    if (err != NO_ERROR) {
        ALOGV("Unable to get output buffers (err=%d)n", err);
        return err;
    }

    while (nFrames <= gNumFrameRecord) {
        size_t bufIndex, offset, size;
        int64_t ptsUsec;
        uint32_t flags;


        ALOGV("Calling dequeueOutputBuffer");
        err = encoder->dequeueOutputBuffer(&bufIndex, &offset, &size, &ptsUsec,
                &flags, kTimeout);
        ALOGV("dequeueOutputBuffer returned %d", err);
        switch (err) {
        case NO_ERROR:
            // got a buffer
            if ((flags & MediaCodec::BUFFER_FLAG_CODECCONFIG) != 0) {
                ALOGV("Got codec config buffer (%zu bytes)", size);
                if (muxer != NULL) {
                    // ignore this -- we passed the CSD into MediaMuxer when
                    // we got the format change notification
                    size = 0;
                }
            }
            if (size != 0) {
                ALOGE("Got data in buffer %zu, size=%zu, pts=%" PRId64 "",bufIndex, size, ptsUsec);

                 {
                    // The MediaMuxer docs are unclear, but it appears that we
                    // need to pass either the full set of BufferInfo flags, or
                    // (flags & BUFFER_FLAG_SYNCFRAME).
                    //
                    // If this blocks for too long we could drop frames.  We may
                    // want to queue these up and do them on a different thread.
                    ATRACE_NAME("write sample");
                    assert(trackIdx != -1);
                    err = muxer->writeSampleData(buffers[bufIndex], trackIdx,
                            ptsUsec, flags);
                    if (err != NO_ERROR) {
                        ALOGV("Failed writing data to muxer (err=%d)n", err);
                        return err;
                    }
                }
                nFrames++;
            }
            err = encoder->releaseOutputBuffer(bufIndex);
            if (err != NO_ERROR) {
                ALOGV("Unable to release output buffer (err=%d)n",
                        err);
                return err;
            }
            if ((flags & MediaCodec::BUFFER_FLAG_EOS) != 0) {
                // Not expecting EOS from SurfaceFlinger.  Go with it.
                ALOGV("Received end-of-stream");

            }
            break;
        case -EAGAIN:                       // INFO_TRY_AGAIN_LATER
            ALOGV("Got -EAGAIN, looping nFrames %d",nFrames);
            nFrames++;
            break;
        case INFO_FORMAT_CHANGED:           // INFO_OUTPUT_FORMAT_CHANGED
            {
                // Format includes CSD, which we must provide to muxer.
                ALOGV("Encoder format changed");
                sp<AMessage> newFormat;
                encoder->getOutputFormat(&newFormat);
                if (muxer != NULL) {
                    trackIdx = muxer->addTrack(newFormat);
                    ALOGV("Starting muxer");
                    err = muxer->start();
                    if (err != NO_ERROR) {
                        ALOGV("Unable to start muxer (err=%d)n", err);
                        return err;
                    }
                }
            }
            break;
        case INFO_OUTPUT_BUFFERS_CHANGED:   // INFO_OUTPUT_BUFFERS_CHANGED
            // Not expected for an encoder; handle it anyway.
            ALOGV("Encoder buffers changed");
            err = encoder->getOutputBuffers(&buffers);
            if (err != NO_ERROR) {
                ALOGV("Unable to get new output buffers (err=%d)n", err);
                return err;
            }
            break;
        case INVALID_OPERATION:
            ALOGV("dequeueOutputBuffer returned INVALID_OPERATION");
            return err;
        default:
            ALOGV("Got weird result %d from dequeueOutputBuffern", err);
            return err;
        }
    }
    ALOGE("Sending EOS of input stream");
    encoder->signalEndOfInputStream();
    return NO_ERROR;
}


TEST(ScoopVideo, video){

    status_t err = NO_ERROR;
    ALOGE("Entering main thread");
    int argc = nn::os::GetHostArgc();
    char** argv = nn::os::GetHostArgv();
    initializeLooperRoster();
    initializeAtomizer();
    initializeDataSource();
    if (argc >= 2) {
        gNumFrameRecord = atoi(argv[1]);
    }
    ALOGE("preparing encoder");
    sp<MediaCodec> enc = prepareEncoder();

    ALOGE("video encoder is readyn");
    if (err != NO_ERROR){
        mEncoder->release();
        //return err; //GFT does not support return value
        return;
    }
    sp<MediaMuxer> muxer = NULL;
    char fileName[] = "c:/temp/ScoopVideoGB.mp4";
    muxer = new MediaMuxer(fileName, MediaMuxer::OUTPUT_FORMAT_MPEG_4);
    ALOGE("MediaMuxer set to MP4");

    err = runEncoder(enc, muxer);

    if (err != NO_ERROR){
        ALOGV("encoder run fails");
        //return err; GFT returns void
        return;
    }

    //destroyEncoderSurface();

    return;

}

/*
//HACK: need to find out if there's an __assert2 and __errno somewhere
__dead void __assert2(const char *, int, const char *, const char *)
{
}*/

volatile int*   __errno()
{
    static int i = 0;
    return &i;
}
