﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
 /*
 * Copyright 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include <cassert>
#include <cctype>
#include <fcntl.h>
//#include <cinttypes>
#include <getopt.h>
#include <csignal>
//#include <stdio.h>
//#include <stdlib.h>
#include <cstring>
#include <sys/wait.h>
#include <termios.h>
//#include <unistd.h>
#define LOG_TAG "ScoopVideo"
//#define LOG_NDEBUG 1
#include <utils/Log.h>
#include <utils/Errors.h>
#include <utils/Timers.h>
#include <utils/Trace.h>
#include <gui/Surface.h>
#include <gui/SurfaceComposerClient.h>
#include <gui/ISurfaceComposer.h>
#include <ui/DisplayInfo.h>
#include <media/openmax/OMX_IVCommon.h>
#include <media/stagefright/foundation/ABuffer.h>
#include <media/stagefright/foundation/AMessage.h>
#include <media/stagefright/MediaCodec.h>
#include <media/stagefright/MediaErrors.h>
#include <media/stagefright/MediaMuxer.h>
#include <media/ICrypto.h>
#include <SfNvnUtil.h>


#include <nn/init.h>
#include <nn/os.h>
#include <nn/nn_Log.h>
#include "SfGlobal.h"

long double strtold (const char *__restrict, char **__restrict);
_Noreturn void _Exit (int);
#include <nn/fs.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <ALooper.h>

#include <nn/nn_Assert.h>
#include "nvos.h"
#include "nvgr.h"
NvOsFileHandle gYuvDump;

//#include "WebmFrame.h"

#ifdef RAPTOR_ENHANCEMENT
extern void initializeLooperRoster();
extern void initializeAtomizer();
extern void initializeDataSource();
#endif
//extern void InitializeWebFrame();
extern void initializeWebFrame();
extern void shutdownWebFrame();

using namespace android;


static const char* kMimeTypeAvc = "video/avc";
static uint32_t gVideoWidth = 1280;        // default width+height
static uint32_t gVideoHeight = 720;
static uint32_t gBitRate = 2000000;     // 2Mbps
static uint32_t gFrameRate = 15;

static volatile bool gStopRequested;
//Previous signal handler state, restored after first hit.

buffer_handle_t mBuffers[2];
sp<IGraphicBufferProducer> mProducer;
sp<IGraphicBufferConsumer> mConsumer;
static SfNvnUtil *gSfNvnUtil;

static int NUM_FRAMES = 300;

namespace{

    const int FsHeapSize = 512 * 1024;

    uint8_t              g_FsHeapBuffer[FsHeapSize];
    nn::lmem::HeapHandle g_FsHeap;

    void FsInitHeap()
    {
        g_FsHeap = nn::lmem::CreateExpHeap(g_FsHeapBuffer, FsHeapSize, nn::lmem::CreationOption_DebugFill);
    }

    void* FsAllocate(size_t size)
    {
        return nn::lmem::AllocateFromExpHeap(g_FsHeap, size);
    }

    void FsDeallocate(void* p, size_t size)
    {
        NN_UNUSED(size);
            return nn::lmem::FreeToExpHeap(g_FsHeap, p);
    }

}
extern "C" void nninitStartup()
{
    const size_t heapSize = 512 << 20;
    const size_t mallocSize = 32 << 20;
    uintptr_t address;
    nn::Result result;

    result = nn::os::SetMemoryHeapSize(heapSize);
    //ASSERT(result.IsSuccess());

    result = nn::os::AllocateMemoryBlock(&address, mallocSize);
    //ASSERT(result.IsSuccess());

    nn::init::InitializeAllocator(reinterpret_cast<void*>(address), mallocSize);
    FsInitHeap();
    nn::fs::SetAllocator(FsAllocate, FsDeallocate);
    NN_SDK_LOG("\ninit done: \n");
}
//HACK: need to find out if there's an __assert2 and __errno somewhere
__dead void __assert2(const char *, int, const char *, const char *)
{
}

volatile int*   __errno()
{
    static int i = 0;
    return &i;
}



/*
 * Configures and starts the MediaCodec encoder.  //Obtains an input surface
 * from the codec.
 */

static status_t prepareEncoder(sp<MediaCodec>* pCodec){

    status_t err;
    sp<AMessage> format = new AMessage;

    format->setInt32("width", gVideoWidth);
    format->setInt32("height", gVideoHeight);
    format->setString("mime", kMimeTypeAvc);
    format->setInt32("encoder", true);
    //format->setInt32("color-format", OMX_COLOR_FormatAndroidOpaque);
    format->setInt32("color-format", OMX_COLOR_FormatYUV420Planar);
    format->setInt32("bitrate", gBitRate);
    format->setFloat("frame-rate", gFrameRate);
    format->setInt32("i-frame-interval", 10);
    //format->setInt32("prepend-sps-pps-to-idr-frames", 0);
    ALOGV("New Looper\n");
    sp<ALooper> looper = new ALooper;
    looper->setName("screenrecord_looper");
    looper->start();
    ALOGV("Creating codec\n");
    sp<MediaCodec> codec = MediaCodec::CreateByType(looper, kMimeTypeAvc, true);
    if (codec == NULL) {
        ALOGV( "ERROR: unable to create %s codec instance\n",
                kMimeTypeAvc);
        return UNKNOWN_ERROR;
    }
    err = codec->configure(format, NULL, NULL,
            MediaCodec::CONFIGURE_FLAG_ENCODE);
    if (err != NO_ERROR) {
        ALOGV( "ERROR: unable to configure %s codec at %dx%d (err=%d)\n",
                kMimeTypeAvc, gVideoWidth, gVideoHeight, err);
        codec->release();
        return err;
    }
    ALOGV("Starting codec");
    err = codec->start();
    if (err != NO_ERROR) {
        ALOGV( "ERROR: unable to start codec (err=%d)\n", err);
        codec->release();
        return err;
    }
    ALOGV("Codec prepared\n");
    *pCodec = codec;
    return err;

}

static status_t prepareVirtualSurface() {

    int width = gVideoWidth;
    int height = gVideoHeight;
    uint32_t format = PIXEL_FORMAT_RGBA_8888;// NVGR_PIXEL_FORMAT_NV12;//HAL_PIXEL_FORMAT_YV12;//
    uint32_t usage = GRALLOC_USAGE_HW_COMPOSER
                   | GRALLOC_USAGE_HW_VIDEO_ENCODER;


    gSfNvnUtil = new SfNvnUtil(width,height,format,usage);

    gSfNvnUtil->OpenGralloc();
    gSfNvnUtil->createEncSurface();

    for (size_t i=0; i<ARRAY_SIZE(mBuffers); i++) {
        gSfNvnUtil->AllocateGrallocBuf(i);
    }

    ALOGE("prepareVirtualSurface success");
    return NO_ERROR;

}

void CaptureFrame(int frameIndex, uint8_t* framedata) {

    status_t err;
    ALOGE("Capture Frame from Virtual Surface");
    err = gSfNvnUtil->captureEncSurface(framedata);
#if 0
    NvOsFwrite(gYuvDump,framedata,(gVideoWidth * gVideoHeight * 3 / 2));
#endif
}

/**
 * Generates the presentation time for frame N, in microseconds.
 */
static long computePresentationTime(int frameIndex) {
    return 132 + frameIndex * 1000000 / gFrameRate;
}
/*
 * Runs the MediaCodec encoder, sending the output to the MediaMuxer.
 *
 * Exactly one of muxer
 *
 * The muxer must *not* have been started before calling.
 */
static status_t runEncoder(const sp<MediaCodec>& encoder,const sp<MediaMuxer>& muxer){
    static int kTimeout = 250000;
    Vector<sp<ABuffer> > mInBuffers;
    Vector<sp<ABuffer> > mOutBuffers;
    ssize_t trackIdx = -1;
    status_t err;
    size_t index;

    bool inputDone = true;
    bool outputDone = false;
    int generateIndex = 0;
    uint8_t *frameData = new uint8_t[gVideoWidth * gVideoHeight * 3 / 2 ];


    err = encoder->getInputBuffers(&mInBuffers);
    if (err != NO_ERROR) {
        ALOGE("Unable to get output buffers (err=%d)\n", err);
        return err;
    }
    err = encoder->getOutputBuffers(&mOutBuffers);
    if (err != NO_ERROR) {
        ALOGE("Unable to get output buffers (err=%d)\n", err);
        return err;
    }
    ALOGV("got %d input and %d output buffers",mInBuffers.size(), mOutBuffers.size());
    while (!outputDone) {
        if(!inputDone) {
            err = encoder->dequeueInputBuffer(&index,kTimeout);
            if (err == OK) {
                long ptsUsec = computePresentationTime(generateIndex);
                if (generateIndex == NUM_FRAMES) {
                    // Send an empty frame with the end-of-stream flag set.  If we set EOS
                    // on a frame with data, that frame data will be ignored, and the
                    // output will be short one frame.
                    err = encoder->queueInputBuffer(
                                index,
                                0 /* offset */,
                                0 /* size */,
                                ptsUsec,
                                MediaCodec::BUFFER_FLAG_EOS);
                    inputDone = true;
                }
                else{
                    ALOGV("filling input buffer %d\n", index);
                   // generateFrame(generateIndex, OMX_COLOR_FormatYUV420Planar, frameData);
                    CaptureFrame(generateIndex,frameData);
                    const sp<ABuffer> &buffer = mInBuffers.itemAt(index);
                    if(buffer->capacity() < gVideoWidth * gVideoHeight * 3 / 2){
                        NN_ASSERT(false &&"Buffer capacity is less than required\n");
                    }
                    // write in buffer frameData
                    memset(buffer->data(), 0, gVideoWidth * gVideoHeight * 3 / 2);
                    memcpy((uint8_t *)buffer->data(),frameData, gVideoWidth * gVideoHeight * 3 / 2);

                    uint32_t bufferFlags = 0;
                    err = encoder->queueInputBuffer(
                            index,
                            0 /* offset */,
                            buffer->size(),
                            ptsUsec,
                            bufferFlags);
                }
                generateIndex++;
            } else {
                 ALOGE("**filling input buffer error %d\n**", index);
            }
        }
        gStopRequested = false;
        if(!gStopRequested) {
            size_t bufIndex, offset, size;
            int64_t ptsUsec;
            uint32_t flags;
            ALOGV("Calling dequeueOutputBuffer");
            err = encoder->dequeueOutputBuffer(&bufIndex, &offset, &size, &ptsUsec,
                    &flags, kTimeout);
            ALOGV("dequeueOutputBuffer returned %d", err);
            inputDone = false;
            switch (err) {

            case NO_ERROR:
                ALOGV("write sampl eGot codec config buffer (%zu bytes)", size);

                ALOGV("Got codec config buffer (%zu bytes)", size);
                if ((flags & MediaCodec::BUFFER_FLAG_CODECCONFIG) != 0) {
                    ALOGV("BUFFER_FLAG_CODECCONFIG (%zu bytes)", size);

                    if (muxer != NULL) {
                        // ignore this -- we passed the CSD into MediaMuxer when
                        // we got the format change notification
                        size = 0;
                    }
                }
                if (size != 0) {
                    if(trackIdx == -1){
                        NN_ASSERT(false && "******TrackIdx != -1 error\n");
                    }
                    ALOGV("\nSet System time :%d\n",ptsUsec);
                    err = muxer->writeSampleData(mOutBuffers[bufIndex], trackIdx,
                                            ptsUsec, flags);
                    if (err != NO_ERROR) {
                        ALOGE("Failed writing data to muxer (err=%d)\n", err);
                        return err;
                    }
                }
                err = encoder->releaseOutputBuffer(bufIndex);
                if (err != NO_ERROR) {
                    ALOGE("Unable to release output buffer (err=%d)\n",err);
                    return err;
                }
                if ((flags & MediaCodec::BUFFER_FLAG_EOS) != 0) {
                    // Not expecting EOS from SurfaceFlinger.  Go with it.
                    ALOGE("Received end-of-stream");
                    gStopRequested = true;
                    outputDone = true;
                }
                break;
            case -EAGAIN:                       // INFO_TRY_AGAIN_LATER
                ALOGV("Got -EAGAIN, looping ..Try again later");//*
                break;
            case INFO_FORMAT_CHANGED:           // INFO_OUTPUT_FORMAT_CHANGED//*
                {
                    // Format includes CSD, which we must provide to muxer.
                    ALOGV("Encoder format changed");
                    sp<AMessage> newFormat;
                    encoder->getOutputFormat(&newFormat);
                    if (muxer != NULL) {
                        trackIdx = muxer->addTrack(newFormat);
                        ALOGV("Starting muxer with trackIdx : %d\n",trackIdx );
                        err = muxer->start();
                        if (err != NO_ERROR) {
                            ALOGE("Unable to start muxer (err=%d)\n", err);
                            return err;
                        }
                    }
                }
                break;
            case INFO_OUTPUT_BUFFERS_CHANGED:   // INFO_OUTPUT_BUFFERS_CHANGED //*
                // Not expected for an encoder; handle it anyway.
                ALOGV("Encoder buffers changed");
                err = encoder->getOutputBuffers(&mOutBuffers);
                if (err != NO_ERROR) {
                    ALOGE("Unable to get new output buffers (err=%d)\n", err);
                    return err;
                }
                break;
            case INVALID_OPERATION:
                ALOGE("dequeueOutputBuffer returned INVALID_OPERATION");
                return err;
            default:
                ALOGE("Got weird result %d from dequeueOutputBuffer\n", err);
                return err;
            }
        }
    }
    ALOGV("Encoder stopping (req=%d)", gStopRequested);
    return NO_ERROR;


}//NOLINT(impl/function_size)

/*
 * Parses args and kicks things off.
 */
extern "C" int nnMain(){

    status_t err;
    sp<MediaCodec> encoder;

    initializeLooperRoster();
    initializeAtomizer();
    initializeDataSource();
    char filename[] = "c:/temp/ScoopVideo.yuv";
    if(NvOsFopen(filename, NVOS_OPEN_WRITE|NVOS_OPEN_CREATE, &gYuvDump)) {
        ALOGE("Fail to open %s file",filename);
    }

    ALOGV("Inside Main, Calling PrepareEncoder\n");
    err = prepareVirtualSurface();
    err = prepareEncoder( &encoder);


    ALOGV("Preprare encoder is ready\n");
    if (err != NO_ERROR){
        encoder->release();
        return err;
    }
    sp<MediaMuxer> muxer = NULL;
    char fileName[] = "c:/temp/ScoopVideo_new.mp4";
    muxer = new MediaMuxer(fileName, MediaMuxer::OUTPUT_FORMAT_MPEG_4);

    err = runEncoder(encoder, muxer);

    if (err != NO_ERROR) {
        ALOGE("RunEncoder failed (err=%d)\n", err);
        encoder->release();
    }

    // release encoder, muxer
    ALOGV("Release Encoder here\n");
    if (encoder != NULL) encoder->release();

    if (muxer != NULL) {
        muxer->stop();
    }

    return 1;
}
