<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        A sandbox script for multimedia capture

    .DESCRIPTION
        This script is modified locally to capture the results of specific videos from Teamcity
        NOTE 1: There is a 30 minute timeout in the testlist that runs this
        NOTE 2: See Integrate\Packages\BundleDefinitions\NX\MultimediaSandbox.bundle.yml if using a file not already specified below
#>

#############################################################################
### Do not modify ### Below ### Do not modify ### Below ### Do not modify ###
#############################################################################

param
(
    [Parameter(Mandatory=$False)]
    [String]
    # The artifact path
    $ArtifactPath
)

# Initialize various paths
$ScriptPath          = $MyInvocation.MyCommand.Path
$ScriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)
$ScriptRootPath      = "$env:NINTENDO_SDK_ROOT"
$ToolsDirectoryPath  = "${scriptRootPath}\Tools\CommandLineTools"
$RunOnTargetExe      = "${toolsDirectoryPath}\RunOnTarget.exe"

if ($ScriptRootPath -eq "")
{
    Write-Error "Error: NINTENDO_SDK_ROOT not set"
    Write-Error "Aborting"
    exit 1
}

# When run locally, the parameter can be left blank to output in the same folder
if ($ArtifactPath -eq "")
{
    $ArtifactPath = ${scriptDirectoryPath}
}

#############################################################################
### Do not modify ### Above ### Do not modify ### Above ### Do not modify ###
#############################################################################

###########
# Sandbox #
###########

###################
Write-Host "--- Starting capture ---"
$DisplayCaptureExe = "${scriptRootPath}\Tests\Outputs\Win32-v140\Tests\DisplayCapture\Develop\DisplayCapture.exe"
$FrameCount = 900
$DisplayCaptureProc = Start-Process -FilePath "${DisplayCaptureExe}" -ArgumentList "-outputFile ${ArtifactPath}/capture.png -CaptureStream ${FrameCount}" -RedirectStandardOutput "${ArtifactPath}/capture.log" -RedirectStandardError "${ArtifactPath}/capture_error.log" -PassThru

###################
Write-Host "--- Playing video ---"
$videoPath = "${scriptRootPath}/video.mp4"
& $runOnTargetExe "${scriptRootPath}\Samples\Outputs\NX-NXFP2-a64\Applications\MediaPlayerSample\Develop\MediaPlayerSample.nsp" -- $videoPath -dm 2

###################
Write-Host "--- Waiting for capture to finish ---"
Wait-Process -InputObject $DisplayCaptureProc

###################
Write-Host "--- Done! ---"
