﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#ifndef _INCLUDED_SfAudioFlinger_h_
#define _INCLUDED_SfAudioFlinger_h_

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/os.h>
#include <nn/fs.h>
#include <nn/init.h>
#include <nnt/nntest.h>

#include <media/MediaPlayerInterface.h>

#ifdef __horizon__
// get NN's audio header file.
#include <nn/audio.h>
#endif




class SfAudioSink : public android::MediaPlayerBase::AudioSink
{
public:
    SfAudioSink();
    virtual             ~SfAudioSink();
    virtual bool        ready() const; // audio output is open and ready
    virtual bool        realtime() const; // audio output is real-time output
    virtual ssize_t     bufferSize() const;
    virtual ssize_t     frameCount() const;
    virtual ssize_t     channelCount() const;
    virtual ssize_t     frameSize() const;
    virtual uint32_t    latency() const;
    virtual float       msecsPerFrame() const;
    virtual int         getSessionId() const;
    virtual uint32_t    getSampleRate() const;

    virtual android::status_t    getTimestamp(android::AudioTimestamp &ts) const;
    virtual audio_stream_type_t  getAudioStreamType() const;
    virtual android::status_t    getFramesWritten(uint32_t *frameswritten) const;
    virtual android::status_t    getPosition(uint32_t *position) const;

    // If no callback is specified, use the "write" API below to submit
    // audio data.
    virtual android::status_t    open(
            uint32_t sampleRate, int channelCount, audio_channel_mask_t channelMask,
            audio_format_t format=AUDIO_FORMAT_PCM_16_BIT,
            int bufferCount=DEFAULT_AUDIOSINK_BUFFERCOUNT,
            android::MediaPlayerBase::AudioSink::AudioCallback cb = NULL,
            void *cookie = NULL,
            audio_output_flags_t flags = AUDIO_OUTPUT_FLAG_NONE,
            const audio_offload_info_t *offloadInfo = NULL);

    virtual android::status_t    start();
    virtual ssize_t     write(const void* buffer, size_t size);
    virtual void        stop();
    virtual void        flush();
    virtual void        pause();
    virtual void        close();
    virtual android::status_t    setRate(float /*rate*/) {
        return android::INVALID_OPERATION;
    }
    virtual android::status_t    getRate(float* /*rate*/) {
        return android::INVALID_OPERATION;
    }
    void ThreadStep();

    int frequency() { return mSampleRate; }



protected:
    int mSampleRate;
    int mChannels;
    int mBufferSize;
    int mFrameSize;
    unsigned mFramesWritten;


    android::MediaPlayerBase::AudioSink::AudioCallback mAwesomeCallback;
    void* mAwesomeCallbackUser;
    uint32_t mLastCbFrames;

    // MoArray<char> mDummy;
    // MoArray<char> mCapture;

    class CallbackThread : public android::Thread
    {
    public:
        SfAudioSink* mAudioSink;
        virtual bool threadLoop();
    };
    android::sp<CallbackThread> mThread;

    // For connection with NN's Audio APIs
    nn::audio::AudioOut audioOut;

    static const int numBuffers = 3;
    static const size_t defaultBufferSize = 4096;
    void *outBuffers[numBuffers];

    nn::audio::AudioOutBuffer audioOutBuffer[numBuffers];

    int numDiffs;
    char decodeBuffer[defaultBufferSize * 2];
    bool bufferCopy;
    uint32_t bufferOffset;
    uint32_t amountToCopy;


};


#endif

