﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Abort.h>
#include <cstdlib>
#include <nn/image/image_ExifExtractor.h>
#include <nn/image/image_JpegDecoder.h>
/**
    @brief FS用アロケータ
 */

class Buffer
{
public:
    explicit Buffer(size_t size) :
        m_data(nullptr),
        m_size(0)
    {
        m_size = size;
        m_data = (size > 0? malloc(m_size): nullptr);
        //m_data = (size > 0? std::malloc(m_size): nullptr);
    }
    ~Buffer()
    {
        if (m_data != nullptr)
        {
            //std::free(m_data);
            free(m_data);
            m_data = nullptr;
        }
    }
    void *GetDataPtr() const
    {
        return m_data;
    }
    size_t GetDataSize() const
    {
        return m_size;
    }

private:
    void *m_data;
    size_t m_size;
};

NN_FORCEINLINE void LogIfNotNull(const char *label, const char *data)
{
    if (data != nullptr)
    {
        NN_LOG("%s: \"%s\"\n", label, data);
    }
}

