﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#ifndef __MEDIADECODER__
#define __MEDIADECODER__

#include <movie/Codec.h>
#include <movie/PlayerExtractor.h>

class MediaDecoder {
public:
    static MediaDecoder* Create();
    int DecodeAudioData(
        const void* in_data,
        int in_len,
        void* out_buf,
        int in_buflen,
        int* out_samplerate,
        int* out_bitspersample,
        int* out_channels,
        int* out_endian);
    ~MediaDecoder();
    MediaDecoder();

private:
    movie::PlayerExtractor* m_pExtractor;
    movie::Codec* m_pCodec;
};

class MediaDecoderCallback : public movie::CodecCallback {
    public:
        MediaDecoderCallback(movie::PlayerExtractor* pExtractor,
            movie::Codec* pCodec,
            void* buffer,
            size_t bufferLen)NN_NOEXCEPT;
        virtual void OnError(movie::Codec* codec, movie::Status result) NN_NOEXCEPT;
        virtual void OnInputBufferAvailable(movie::Codec* codec, int index) NN_NOEXCEPT;
        virtual void OnOutputBufferAvailable(movie::Codec* codec,
                int index,
                int64_t presentationTimeUs,
                uint32_t flags) NN_NOEXCEPT;
        virtual void OnOutputFormatChanged(movie::Codec* codec, movie::MediaData* format) NN_NOEXCEPT;
        bool DecodeComplete();
        size_t BytesDecoded();
    private:
        void SendEosToCodec();
        bool m_ReachedEos;
        movie::PlayerExtractor* m_pExtractor;
        movie::Codec* m_pCodec;
        bool m_decodeComplete;
        uint8_t* m_pWritePos;
        size_t m_outBufLen;
        size_t m_numBytesDecoded;
};
#endif
