﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "HeapTracker.h"
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/nn_SdkLog.h>

#include <algorithm>
#include <cinttypes>

namespace movie { namespace sample {

void HeapTracker::Track(void* memory, size_t size) {
    if (memory == nullptr) return;

    current_size_ += size;
    if (current_size_ > max_size_) max_size_ = current_size_;

    auto it = std::find_if(begin(allocations_), end(allocations_), [](auto const& e) { return e.address_ == nullptr; });
    if (it == end(allocations_)) { allocations_.emplace_back(AllocationInfo{memory, size}); return; }

    it->address_ = memory;
    it->size_ = size;
}

void HeapTracker::Untrack(void* memory) {
    if (memory == nullptr) return;

    auto it = std::find_if(begin(allocations_),end(allocations_), [&](auto const& e){ return e.address_ == memory; });
    if (it == end(allocations_)) {
        NN_SDK_LOG("HeapTracker: Allocation not tracked: 0x%p\n", memory);
        return;
    }

    current_size_ -= it->size_;

    it->address_ = nullptr;
    it->size_ = 0;
}

void HeapTracker::OutputUsage()
{
    size_t total_size_{};
    for (auto&& e : allocations_) {
        if (e.address_ == nullptr) continue;
        total_size_ += e.size_;
        NN_SDK_LOG("leaked entry : size == %" PRIu64 ", address == 0x%p\n", e.size_, e.address_);
    }

    NN_LOG("current size: %" PRIu64 ", high water size: %" PRIu64 "\n", total_size_, max_size_);
    NN_ABORT_UNLESS(current_size_ == total_size_, "HeapTracker error: mismatch in current_size (%" PRIu64 ") and measured total_size (%" PRIu64 ")\n");
}

}}

