﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/os.h>
#include <nvddk_vic.h>
#include <nvrm_surface.h>

class VicSession
{
public:
    VicSession(NvRmDeviceHandle, std::uint32_t, std::uint32_t) NN_NOEXCEPT;
    virtual ~VicSession() NN_NOEXCEPT;

    NvError Execute(NvRmSurface*, int, const NvDdkVicFloatColor&) NN_NOEXCEPT;
    NvError ExecuteI(NvDdkVicConfigParameters*, NvRmSurface*, int nSurfaces) NN_NOEXCEPT;

    NvRmSurface* GetOutput() NN_NOEXCEPT;
    NvDdkVicSession *GetSession() NN_NOEXCEPT {return m_pSession;} ;

private:
    NvRmDeviceHandle m_Device;
    NvDdkVicSession* m_pSession;
    NvRmSurface m_Target;

    void InitializeTargetSurface(std::uint32_t, std::uint32_t) NN_NOEXCEPT;
};
