﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// -----------------------------
//
//  Note - JB 6/4/2015
//    This program no longer builds in Windows.   Bunch of errors in horizonbase\pthread.h, and usleep() not defined.
//    nact doesn't build this, so it won't break the windows/nact build.
//
//
// ---------------------------------

#ifdef WIN32
//#define USE_WIN32_MALLOC_IMPLEMENTATION               // #define if want to use Win32 code rather than horizons..
#endif

#include <stdint.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>

#ifdef USE_WIN32_MALLOC_IMPLEMENTATION
    #include <Win\platform\WinAlloc.h>
    #include <Win\platform\pthreads-w32-2-8-0-release\pthread.h>
    #pragma comment(lib, "libmm_windows.lib")
    #pragma comment(lib, "libmm_pthreads.lib")
#else
    #include <Horizon\platform\HorizonAlloc.h>
    #include <Horizon\platform\HorizonBase\pthread.h>
    //#pragma comment(lib, "libmm_horizon.lib")
#endif




//extern int usleep(unsigned long usec );     // where does this come from?

//-----------------------------------------------------------------------------

namespace {

const size_t           ThreadStackSize = 8192;
const size_t           ThreadStackAlignment = 4096;
char  *g_ThreadStack1;
char  *g_ThreadStack2;
nn::os::ThreadType  g_Thread1;
nn::os::ThreadType  g_Thread2;
//nn::os::ThreadType  g_PThread1;
//nn::os::ThreadType  g_PThread2;
pthread_mutex_t mutex;

}   // namespace

//-----------------------------------------------------------------------------

//
//  Ã£â??Â¹Ã£Æ?Â¬Ã£Æ?Æ?Ã£Æ?â?°Ã¦Æ?â?¦Ã¥Â Â±Ã£â??â??Ã¨Â¡Â¨Ã§Â¤Âº
//
void    PrintThreadInfo(const char* name, nn::os::ThreadType* thread)
{
    NN_LOG("[%s]\n", name);

    const char* threadName = nn::os::GetThreadNamePointer( thread );
    NN_LOG("name     : %s\n", threadName);
    NN_LOG("priority : %d\n", nn::os::GetThreadPriority( thread ));
    NN_LOG("core No. : %d\n", nn::os::GetCurrentCoreNumber());
    NN_LOG("\n");
}


//
//  1 Ã£ÂÂ¤Ã§â?ºÂ®Ã£ÂÂ®Ã£â??Â¹Ã£Æ?Â¬Ã£Æ?Æ?Ã£Æ?â?°
//
void ThreadFunction1(void *arg)
{
    NN_UNUSED(arg);

    PrintThreadInfo( "thread1", &g_Thread1 );
}

void *PThreadCommonFunction()
{

    NN_LOG("PthreadCommonFunction: Knocking on critical section\n");
    pthread_mutex_lock(&mutex);
    pthread_t pth = pthread_self();
    NN_LOG("PthreadCommonFunction: inside critical section, thid = %d\n", pth);
    usleep(200);
    pthread_mutex_unlock(&mutex);
    NN_LOG("PthreadCommonFunction: out of critical section\n");

    //PrintThreadInfo( "Pthread1", &g_PThread1 );
    return NULL;
}

void *PThreadFunction2(void *arg)
{
    NN_UNUSED(arg);
    NN_LOG("In PthreadFunction2\n");
    PThreadCommonFunction();

    //PrintThreadInfo( "Pthread1", &g_PThread1 );
    return NULL;
}

void *PThreadFunction1(void *arg)
{
    NN_UNUSED(arg);
    NN_LOG("In PthreadFunction1\n");
    PThreadCommonFunction();

    //PrintThreadInfo( "Pthread1", &g_PThread1 );
    return NULL;
}

//
//  2 Ã£ÂÂ¤Ã§â?ºÂ®Ã£ÂÂ®Ã£â??Â¹Ã£Æ?Â¬Ã£Æ?Æ?Ã£Æ?â?°
//
void ThreadFunction2(void *arg)
{
    NN_UNUSED(arg);

    // Ã£â??Â¹Ã£Æ?Â¬Ã£Æ?Æ?Ã£Æ?â?° 1 Ã£ÂÅ?Ã§Â µâ??Ã¤Âºâ? Ã£Ââ?¢Ã£â??â?¹Ã£ÂÂ®Ã£â??â??Ã¥Â¾â?¦Ã£ÂÂ¤
    nn::os::WaitThread( &g_Thread1 );

    PrintThreadInfo( "thread2", &g_Thread2 );

    // Ã£â??Â¹Ã£Æ?Â¬Ã£Æ?Æ?Ã£Æ?â?° 2 Ã£ÂÂ®Ã¥ÂÂÃ¥â?°ÂÃ£â??â??Ã¥Â¤â?°Ã¦â?ºÂ´
    NN_LOG("Change name of thread2\n");
    nn::os::SetThreadName( &g_Thread2, "Thread2_NewName" );

    // Ã£â??Â¹Ã£Æ?Â¬Ã£Æ?Æ?Ã£Æ?â?° 2 Ã£ÂÂ®Ã¥â??ÂªÃ¥â?¦Ë?Ã¥ÂºÂ¦Ã£â??â??Ã¥Â¤â?°Ã¦â?ºÂ´
    NN_LOG("Change priority of thread2 to 5\n");
    nn::os::ChangeThreadPriority( &g_Thread2, 5 );

    NN_LOG("\n");
    PrintThreadInfo( "thread2", &g_Thread2 );
}


extern "C" void nnMain()
{
    nn::Result      result;
    pthread_t       th, th2;
    pthread_attr_t  attr, attr2;

    pthread_mutex_init(&mutex, NULL);

    MV_HeapCreate(32);        // specify how much of total heap space used by our malloc
    g_ThreadStack1 = (char *)MV_malloc_aligned(ThreadStackSize, ThreadStackAlignment);
    g_ThreadStack2 = (char *)MV_malloc_aligned(ThreadStackSize, ThreadStackAlignment);

    NN_LOG("Aligned Stack Addr1: 0x%p\n", g_ThreadStack1);
    NN_LOG("Aligned Stack Addr2: 0x%p\n", g_ThreadStack2);

    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_JOINABLE);
    pthread_create(&th, &attr, PThreadFunction1, NULL);
    pthread_attr_destroy(&attr);

    pthread_attr_init(&attr2);
    pthread_attr_setdetachstate(&attr2, PTHREAD_CREATE_JOINABLE);
    pthread_create(&th2, &attr2, PThreadFunction2, NULL);
    pthread_attr_destroy(&attr2);

    /*
    result = nn::os::CreateThread( &g_Thread1, ThreadFunction1, NULL, g_ThreadStack1, ThreadStackSize, nn::os::DefaultThreadPriority );
    NN_ASSERT( result.IsSuccess(), "Cannot create g_Thread1." );

    result = nn::os::CreateThread( &g_Thread2, ThreadFunction2, NULL, g_ThreadStack2, ThreadStackSize, nn::os::DefaultThreadPriority );
    NN_ASSERT( result.IsSuccess(), "Cannot create g_Thread2." );

    nn::os::StartThread( &g_Thread1 );
    nn::os::StartThread( &g_Thread2 );

    nn::os::WaitThread( &g_Thread1 );
    nn::os::WaitThread( &g_Thread2 );

    nn::os::DestroyThread( &g_Thread1 );
    nn::os::DestroyThread( &g_Thread2 );
    */
    usleep(1000);
    void *dummy;
    pthread_join (th, &dummy);
    NN_LOG("pthread_join complete for thread#1\n");

    pthread_join (th2, &dummy);
    NN_LOG("pthread_join complete for thread#2\n");

    MV_free_aligned(g_ThreadStack1);
    MV_free_aligned(g_ThreadStack2);
    MV_HeapDestroy();
}
