﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Abort.h>
#include <nn/ldn.h>

// デバッグ用のログ出力関数です。
const char* ConvertToString(const nn::ldn::Ipv4Address& ipv4Address) NN_NOEXCEPT;
const char* ConvertToString(const nn::ldn::SubnetMask& subnetMask) NN_NOEXCEPT;

// 失敗時に Result を return するユーティリティです。
#define NNS_LDN_RETURN_IF_FAILED(result)\
    do\
    {\
        ::nn::Result temporaryResult = (result);\
        if (temporaryResult.IsSuccess()) { } else { return temporaryResult; }\
    } while (0)\

// 失敗時に Abort するユーティリティです。
#define NNS_LDN_ABORT_UNLESS_RESULT_SUCCESS(result) NN_ABORT_UNLESS((result).IsSuccess())
