﻿# 検証に使用するツールのパスです。
$LDN_TEST_BRIDGE = "$SIGLO_ROOT\Tests\Outputs\AnyCPU\Tools\LdnTestBridge\Release\LdnTestBridge.exe"
$RUN_UNIT = "$SIGLO_ROOT\Tests\Ldn\Sources\Scripts\Runner\RunUnit.ps1"

# 並行してテストを実行します。
Function RunParallel($Targets, $SceneId, $HostPath, $ClientPath)
{
    Write-Host $HostPath $Args
    
    # LdnTestBridge を起動しておきます。
    $BridgeJobs += Start-Job -ArgumentList $LDN_TEST_BRIDGE -ScriptBlock {
        Param($LDN_TEST_BRIDGE)
        &$LDN_TEST_BRIDGE
    }
    
    # テストを実行します。
    $RunJobs = @()
    foreach ($Target in $Targets)
    {
        $RunJobs += Start-Job -ArgumentList `
            $Target,$Targets.Length,$SceneId,$HostPath,$ClientPath,$Args,$RUN_UNIT -ScriptBlock `
        {
            Param($Target, $Num, $SceneId, $HostPath, $ClientPath, $Arguments, $SCRIPT)
            $ErrorActionPreference = "Stop"
            $Path = if ($Target.Index -eq 0) { $HostPath } else { $ClientPath }
            & $SCRIPT $Target.Name $Target.Index $Num $Path $SceneId @Arguments
       }
    }

    # テストの終了まで待機します。
    $ErrorCount = 0
    while ($RunJobs.length -gt 0)
    {
        $NextJobs = @()
        foreach ($Job in $RunJobs)
        {
            try
            {
                $IsFinished = (Wait-Job $Job -Timeout 1)
                $Result = Receive-Job $Job -ErrorAction Stop
                if ($Result)
                {
                    # Write-Host ($Result -join "`n")
                }
                if ($IsFinished -eq $NULL)
                {
                    $NextJobs += $Job
                }
                else
                {
                    Remove-Job -Force $Job               
                }
            }
            catch
            {
                $ErrorCount += 1
                Remove-Job -Force $Job
            }
        }
        $RunJobs = $NextJobs
    }
    $BridgeJobs | Stop-Job -PassThru | Remove-Job -Force
    Write-Host ErrorCount: $ErrorCount
    return $ErrorCount
}
