﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nnt/lcs/testLcs_Utility.h>
#include <nnt/ldn/testLdn_Synchronization.h>

/**
    * @brief       テストの実行を支援します。
    */
class SystemDeliveryProtocolTestHelper
{
public:

    /**
        * @brief       コンストラクタです。
        * @param[in]   config              テストの設定です。
        * @param[in]   group               同期に使用するグループ名です。
        */
    SystemDeliveryProtocolTestHelper(
        const nnt::lcs::TestConfig& config, const char* group) NN_NOEXCEPT;

    /**
        * @brief       テストの実行を開始します。
        * @param[in]   cond                テストの条件です。
        * @param[in]   prefix              同期に使用する名前の接頭辞です。
        * @param[in]   requiredNodeCount   テストの実行に必要な端末数です。
        */
    void RunTest(
        const nnt::lcs::Precondition& cond, const char* prefix, int requiredNodeCount) NN_NOEXCEPT;

private:

    void RunTestImpl(
        const nnt::lcs::Precondition& cond) NN_NOEXCEPT;

    void StartHost(
        const nnt::lcs::Precondition& cond, nn::os::SystemEventType* pEvent) NN_NOEXCEPT;

    void StartClient(
        const nnt::lcs::Precondition& cond, nn::os::SystemEventType* pEvent) NN_NOEXCEPT;

    void Sync(const char* keyword) NN_NOEXCEPT;

    nnt::ldn::ISynchronization* m_pSync;
    nnt::lcs::TestConfig m_TestConfig;
    char m_Group[nnt::ldn::SynchronizationGroupNameLengthMax + 1];
    char m_Prefix[nnt::lcs::PrefixLengthMax + 1];
};
