﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Abort.h>
#include <nnt/lcs/testLcs_Utility.h>

void SetPatchRequiredSystemVersionPrecondition(
    nnt::lcs::PreconditionSource* pSource,
    const char* test,
    nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(applicationId);
    auto& source = *pSource;
    if (std::strcmp(test, "HostToAllClients") == 0)
    {
        source.SetSystemVersion(2, 1, 1);
        source.SetApplicationVersion(2, 1, 1);
        source.SetApplicationRequiredSystemVersion(2, 1, 1);
    }
    else if (std::strcmp(test, "HostToSomeClients") == 0)
    {
        source.SetSystemVersion(3, 2, 1);
        source.SetApplicationVersion(2, 3, 1);
        source.SetApplicationRequiredSystemVersion(1, 2, 1);
    }
    else if (std::strcmp(test, "ClientToHostAndAllOtherClients") == 0)
    {
        source.SetSystemVersion(1, 2, 1);
        source.SetApplicationVersion(1, 2, 1);
        source.SetApplicationRequiredSystemVersion(1, 2, 1);
    }
    else if (std::strcmp(test, "ClientToHost") == 0)
    {
        source.SetSystemVersion(1, 3, 2);
        source.SetApplicationVersion(1, 2, 3);
        source.SetApplicationRequiredSystemVersion(1, 1, 2);
    }
    else if (std::strcmp(test, "ClientToHostAndOneClient") == 0)
    {
        source.SetSystemVersion(1, 1, 2);
        source.SetApplicationVersion(1, 1, 2);
        source.SetApplicationRequiredSystemVersion(1, 1, 2);
    }
    else if (std::strcmp(test, "ClientToOneClient") == 0)
    {
        source.SetSystemVersion(2, 1, 3);
        source.SetApplicationVersion(3, 1, 2);
        source.SetApplicationRequiredSystemVersion(2, 1, 1);
    }
    else if (std::strcmp(test, "NotRequired") == 0)
    {
        source.SetSystemVersion(3, 2, 2);
        source.SetApplicationVersion(3, 2, 1);
        source.SetApplicationRequiredSystemVersion(2, 1, 1);
    }
    else
    {
        NN_ABORT("Unknown Test: PatchRequiredSystemVersion.%s\n", test);
    }
}

void SetLcsRequiredSystemVersionPrecondition(
    nnt::lcs::PreconditionSource* pSource,
    const char* test,
    nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(applicationId);
    auto& source = *pSource;
    if (std::strcmp(test, "HostToAllClients") == 0)
    {
        source.SetSystemVersion(2, 1, 1);
        source.SetSystemRequiredSystemVersion(2, 1, 1);
        source.SetApplicationVersion(2, 1, 1);
    }
    else if (std::strcmp(test, "HostToSomeClients") == 0)
    {
        source.SetSystemVersion(3, 2, 1);
        source.SetSystemRequiredSystemVersion(2, 1, 1);
        source.SetApplicationVersion(2, 3, 1);
    }
    else if (std::strcmp(test, "ClientToHostAndAllOtherClients") == 0)
    {
        source.SetSystemVersion(1, 2, 1);
        source.SetSystemRequiredSystemVersion(1, 2, 1);
        source.SetApplicationVersion(1, 2, 1);
    }
    else if (std::strcmp(test, "ClientToHost") == 0)
    {
        source.SetSystemVersion(1, 3, 2);
        source.SetSystemRequiredSystemVersion(1, 2, 1);
        source.SetApplicationVersion(1, 2, 3);
    }
    else if (std::strcmp(test, "ClientToHostAndOneClient") == 0)
    {
        source.SetSystemVersion(1, 1, 2);
        source.SetSystemRequiredSystemVersion(1, 1, 2);
        source.SetApplicationVersion(1, 1, 2);
    }
    else if (std::strcmp(test, "ClientToOneClient") == 0)
    {
        source.SetSystemVersion(2, 1, 3);
        source.SetSystemRequiredSystemVersion(1, 1, 2);
        source.SetApplicationVersion(3, 1, 2);
    }
    else if (std::strcmp(test, "NotRequired") == 0)
    {
        source.SetSystemVersion(3, 2, 2);
        source.SetSystemRequiredSystemVersion(2, 2, 1);
        source.SetApplicationVersion(3, 2, 1);
    }
    else
    {
        NN_ABORT("Unknown Test: Lcs.RequiredSystemVersion.%s\n", test);
    }
}

void SetApplicationDeliveryProtocolPrecondition(
    nnt::lcs::PreconditionSource* pSource,
    const char* test,
    nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(applicationId);
    auto& source = *pSource;
    if (std::strcmp(test, "HostToAllClients") == 0)
    {
        source.SetSystemVersion(2, 1, 1);
        source.SetApplicationDeliveryProtocolVersion(2, 1, 1, false);
        source.SetApplicationVersion(2, 1, 1);
    }
    else if (std::strcmp(test, "HostToSomeClients") == 0)
    {
        source.SetSystemVersion(3, 2, 1);
        source.SetApplicationDeliveryProtocolVersion(2, 2, 1, false);
        source.SetApplicationVersion(2, 3, 1);
    }
    else if (std::strcmp(test, "ClientToHostAndAllOtherClients") == 0)
    {
        source.SetSystemVersion(1, 2, 1);
        source.SetApplicationDeliveryProtocolVersion(1, 2, 1, false);
        source.SetApplicationVersion(1, 2, 1);
    }
    else if (std::strcmp(test, "ClientToHost") == 0)
    {
        source.SetSystemVersion(1, 3, 2);
        source.SetApplicationDeliveryProtocolVersion(1, 2, 2, false);
        source.SetApplicationVersion(1, 2, 3);
    }
    else if (std::strcmp(test, "ClientToHostAndOneClient") == 0)
    {
        source.SetSystemVersion(1, 1, 2);
        source.SetApplicationDeliveryProtocolVersion(1, 1, 2, false);
        source.SetApplicationVersion(1, 1, 2);
    }
    else if (std::strcmp(test, "ClientToOneClient") == 0)
    {
        source.SetSystemVersion(2, 1, 3);
        source.SetApplicationDeliveryProtocolVersion(2, 1, 2, false);
        source.SetApplicationVersion(3, 1, 2);
    }
    else if (std::strcmp(test, "NotRequired") == 0)
    {
        source.SetSystemVersion(3, 2, 1);
        source.SetApplicationDeliveryProtocolVersion(2, 2, 1, true);
        source.SetApplicationVersion(3, 2, 1);
    }
    else
    {
        NN_ABORT("Unknown Test: Lcs.RequiredSystemVersion.%s\n", test);
    }
}

void SetDiscontinuePrecondition(
    nnt::lcs::PreconditionSource* pSource,
    const char* test,
    nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(applicationId);
    auto& source = *pSource;
    if (std::strcmp(test, "LeaveSuspendedWithRebootRequired") == 0)
    {
        source.scenario = nnt::lcs::Scenario_LeaveAtSuspendedReasonRebootRequired;
        source.SetSystemVersion(2, 1, 1);
        source.SetApplicationVersion(2, 1, 1);
        source.SetApplicationRequiredSystemVersion(2, 1, 1);
    }
    else if (std::strcmp(test, "ResumeWithoutReboot") == 0)
    {
        source.scenario = nnt::lcs::Scenario_ResumeWithoutReboot;
        source.SetSystemVersion(2, 1, 1);
        source.SetApplicationVersion(2, 1, 1);
        source.SetApplicationRequiredSystemVersion(2, 1, 1);
    }
    else
    {
        NN_ABORT("Unknown Test: Lcs.Discontinue.%s\n", test);
    }
}

nnt::lcs::Precondition GetPrecondition(
    const char* testcase, const char* test, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(testcase);
    NN_UNUSED(test);
    auto source = nnt::lcs::CreateDefaultPreconditionSource();
    source.application.id = applicationId;
    if (std::strcmp(testcase, "LupPatchRequiredSystemVersion") == 0)
    {
        SetPatchRequiredSystemVersionPrecondition(&source, test, applicationId);
    }
    else if (std::strcmp(testcase, "LupLcsRequiredSystemVersion") == 0)
    {
        SetLcsRequiredSystemVersionPrecondition(&source, test, applicationId);
    }
    else if (std::strcmp(testcase, "LupApplicationDeliveryProtocol") == 0)
    {
        SetApplicationDeliveryProtocolPrecondition(&source, test, applicationId);
    }
    else if (std::strcmp(testcase, "LupDiscontinue") == 0)
    {
        SetDiscontinuePrecondition(&source, test, applicationId);
    }
    else
    {
        NN_ABORT("Unknown Testcase: %s\n", testcase);
    }
    return Calculate(source);
}

nnt::lcs::Precondition GetPrecondition(
    const char* testcase, const char* test, uint64_t applicationId) NN_NOEXCEPT
{
    nn::ncm::ApplicationId id = { applicationId };
    return GetPrecondition(testcase, test, id);
}
