﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nnt/lcs/testLcs_Request.h>
#include <nn/util/util_FormatString.h>

namespace nnt { namespace lcs { namespace
{
    void Request(const char* command) NN_NOEXCEPT
    {
        NN_LOG("[LCS] Runner Operation: %s\n", command);
    }

}}} // namespace nnt::lcs::<unnamed>

namespace nnt { namespace lcs
{
    void RequestReboot() NN_NOEXCEPT
    {
        Request("REBOOT");
    }

    void RequestResume() NN_NOEXCEPT
    {
        Request("RESUME");
    }

    void RequestFirmwareDebugParameterUpdate(
        const char* name, const char* key, int value) NN_NOEXCEPT
    {
        char command[255];
        nn::util::SNPrintf(command, sizeof(command), "SET integer %s %s %d", name, key, value);
        Request(command);
    }

    void RequestApplicationDeliveryProtocolVersionUpdate(int version) NN_NOEXCEPT
    {
        RequestFirmwareDebugParameterUpdate(
            "contents_delivery", "application_delivery_protocol_version", version);
    }

    void RequestDevMenuCommandSystem(const char* argument) NN_NOEXCEPT
    {
        char command[255];
        nn::util::SNPrintf(command, sizeof(command), "COMMAND %s", argument);
        Request(command);
    }

}} // namespace nnt::lcs
