﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>
#include <nn/init.h>
#include <nn/oe.h>
#include <nn/os.h>
#include <nn/ae.h>
#include <nn/la/la_Api.h>

#include <nn/la/la_CommonArgumentsReader.h>

void LibraryAppletNetConnectMain(const nn::ae::LibraryAppletSelfInfo& info) NN_NOEXCEPT
{
    NN_LOG("===== DummyError Start =====\n");

    nn::la::CommonArgumentsReader commonArgumentsReader;

    ASSERT_TRUE(commonArgumentsReader.TryPopFromInChannel());

    EXPECT_EQ(123, commonArgumentsReader.GetLaVersion());
    EXPECT_EQ(nn::oe::ThemeColorType_Default, commonArgumentsReader.GetColorIndex());
    EXPECT_TRUE(commonArgumentsReader.IsPlayStartupSound());

    NN_LOG("CommonArguments:\n");
    NN_LOG("  laVersion = %d\n", commonArgumentsReader.GetLaVersion());
    NN_LOG("  colorIndex = %d\n", commonArgumentsReader.GetColorIndex());
    NN_LOG("  isPlayStartupSound = %s\n", commonArgumentsReader.IsPlayStartupSound() ? "true" : "false");
}

extern "C" void nninitStartup()
{
    // 本サンプルはアプレット向け desc を利用しており、アプレット向けのリソース制限が適用されます。
    // ここでは、デフォルトの nninitStartup() のデフォルトメモリアロケータのサイズが
    // アプレットで利用できるサイズ上限を超えているため、自前で nninitStartup() を用意しています。
}

extern "C" void nnMain()
{
    nn::ae::InvokeLibraryAppletMain(LibraryAppletNetConnectMain);
}

