﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.jit.testvm
{
    [CppRefPath(@"../Common/IProtoJitLoader.sfdl.h")]
    public interface IJitCompileEnvironment : IServiceObject
    {
        [MethodId(1)]
        Result GetCodeAddress(Out<uint64_t> pOut);

        [MethodId(10)]
        Result ShareRom(uint64_t tag, NativeHandle transferMemoryHandle, uint64_t size);
    }

    [CppRefPath(@"../Common/IProtoJitLoader.sfdl.h")]
    public interface ITestVmJitCompileEnvironment : IJitCompileEnvironment
    {
        [MethodId(100)]
        Result SetupTestVmCompiler();

        [MethodId(101)]
        Result GenerateCode(Out<uint64_t> pEntry, Out<uint64_t> pCodeSize, Out<uint32_t> pInstructionCount, int32_t pc);
    }

    [CppRefPath(@"../Common/IProtoJitLoader.sfdl.h")]
    public interface IJitEnvironment : IServiceObject
    {
        [MethodId(1)]
        Result CreateTestVmJitCompileEnvironment(Out<ITestVmJitCompileEnvironment> pOut);
    }

    [CppRefPath(@"../Common/IProtoJitLoader.sfdl.h")]
    public interface IProtoJitLoader2 : IServiceObject
    {
        [MethodId(1)]
        Result CreateJitEnvironment(Out<IJitEnvironment> pOut, NativeHandle processHandle, [ProcessId] Bit64 processId, uint64_t bufferAddress, uint64_t bufferSize);
    }
}
