﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <queue>
#include <string>

#include <nn/fs.h>
#include <nn/fs/fs_Debug.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_TickTypes.h>

#include <nn/nn_Assert.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>
#include <nn/util/util_FormatString.h>

#include "AttachmentDataFormat.h"
#include "GraphicsSystem.h"

class AttachmentLogger
{
    NN_DISALLOW_COPY(AttachmentLogger);
    NN_DISALLOW_MOVE(AttachmentLogger);

public:
    static const int   FileNameCountMax = 256;

private:
    nn::fs::FileHandle m_FileHandle;
    int64_t            m_FileOffset;
    char               m_FileName[FileNameCountMax];
    char               m_DirName[FileNameCountMax];

    bool               m_IsSdCardInserted;

    nn::os::Tick       m_StartTick;

    static const char* Format;
    static const char* MountName;

    ::std::queue<::std::string> m_LineQueue;

public:
    AttachmentLogger() NN_NOEXCEPT;

    void Initialize(const char* pDirName) NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;

    void AppendLineFormat(int indexCountMax) NN_NOEXCEPT;

    void AppendLine(const AttachmentOutput& output, const RecordInfo& info, int indexCountMax) NN_NOEXCEPT;

    void Write(const char* pFileName) NN_NOEXCEPT;

    void WritePng(const char* pFileName, GraphicsSystem* pGraphicsSystem) NN_NOEXCEPT;

private:
    void AppendLine(const char* str, int length) NN_NOEXCEPT;

};
