﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_Vector.h>
#include <nn/irsensor.h>
#include <nn/hid/hid_NpadSixAxisSensor.h>

const int IrCameraSafetyFramePixel = 15; //!< カメラ単体の安全フレーム
const int IrCameraNeighborMarginPixel = 25; //!< 近傍判定のマージンサイズ
const int AttachmentNameSizeMax = 16; //!< アタッチメント名の最大長
const int FileNameSizeMax = 128; //!< アタッチメント名の最大長

struct MeasuredClusterData
{
    int clusterId;  //!< クラスタID
    bool isValid;   //!< 検出されたクラスタが有効かどうか
    nn::irsensor::ClusteringData measuredClusteringData; // 測定されたクラスタデータ
};

struct IdentifiedClusterData
{
    int clusterId; //!< クラスタID
    nn::irsensor::ClusteringData idealClusteringData; //!< 理想のクラスタデータ
};

struct PixelPosition
{
    int x;
    int y;
};

struct IrCameraCalibrationValue
{
    PixelPosition position[9]; //!< 左上を index0とするキャリブレーション情報
};

struct AttachmentOutput
{
    nn::irsensor::Rect outMostFrame; //!< マーカの移動範囲の最外矩形
    nn::util::Float2 centerPoint; //!< マーカー移動範囲の中心座標[pix]
    int objectCount;       //!< 検出されたクラスタデータの個数
    MeasuredClusterData clusters[nn::irsensor::ClusteringProcessorObjectCountMax];  //!< 識別された個々のクラスタデータ
    int objectRawCount;   //!< 生データの数
    nn::irsensor::ClusteringData rawClusterData[nn::irsensor::ClusteringProcessorObjectCountMax]; //!< 撮影時点のクラスタ生データ
    nn::hid::SixAxisSensorState sixAxisData; //!< 右コンの6軸データ
    nn::util::Vector3f sixAxisDegreeData; //!< 右コンの加速度から計算した角度データ
};

struct AttachmentInput
{
    char attachmentName[AttachmentNameSizeMax]; //!< アタッチメント名
    int safetyFramePixelX; //!< X軸方向の安全フレームのサイズ[px]
    int safetyFramePixelY; //!< Y軸方向の安全フレームのサイズ[px]
    int objectCount;       //!< クラスタデータの個数の最大値
    IdentifiedClusterData expectedClusters[nn::irsensor::ClusteringProcessorObjectCountMax];  //!< 順番IDを持ったクラスタデータの期待値
    nn::irsensor::ClusteringProcessorConfig clusteringConfig; //!< クラスタリングモードの設定
};

struct RecordInfo
{
    int attachmentVersionId; //!< アタッチメントバージョンのID
    int attachmentId;        //!< アタッチメントの個体番号
    int measuredCameraId;    //!< 撮影したカメラの個体番号
};

struct PathInfo
{
    char directoryName[FileNameSizeMax];
    char logFileName[FileNameSizeMax];
    char pngFileName[FileNameSizeMax];
};
