﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx/util/gfx_DebugFontTextWriter.h>
#include <nn/hid.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/irsensor.h>

#include "HandAnalysisUtil.h"

namespace {

const char* ToolVersion= "ApiTool v5.3";

const size_t ApplicationHeapSize = 128 * 1024 * 1024;

#if defined(NN_BUILD_TARGET_PLATFORM_NX)
const size_t GraphicsMemorySize = 8 * 1024 * 1024;
#endif

const int MaxIrSensorCount = 2;
const int MaxPerformanceArraySize = 600; // 10秒

const float DisplayWidth = 1280.0f;
const float DisplayHeight = 720.0f;

const float MenuBarOffsetY = 0.0f;
const float MenuImageOffsetX = 30.0f;
const float MenuOutputOffsetY = 45.0f;
const float MenuPerformanceOffsetY = 30.0f;
const float MenuResultOffsetX = 430.0f;
const float MenuParameterOffsetX = 700.0f;
const float MenuOutputConfigOffsetX = 980.0f;
const float MenuHelpOffsetX = MenuOutputConfigOffsetX;
const float MenuHelpOffsetY = 190.0f;
const float MenuToolVersionX = 1170.0f;
const float MenuToolVersionY = 5.0f;
const float MenuFpsX = MenuToolVersionX;
const float MenuFpsY = MenuToolVersionY + DisplayHeight / 2;

enum IrSensorApiTestToolState
{
    IrSensorApiTestToolState_Initial,
    IrSensorApiTestToolState_Initialized,
    IrSensorApiTestToolState_CameraReady,
    IrSensorApiTestToolState_Running,
    IrSensorApiTestToolState_StateNum,
};

enum IrSensorMode
{
    IrSensorMode_Moment = 0,
    IrSensorMode_Clustering = 1,
    IrSensorMode_ImageTransfer = 2,
    IrSensorMode_Pointing = 3,
    IrSensorMode_HandAnalysis = 4,
    IrSensorMode_IrLed = 5,
    IrSensorMode_AdaptiveClustering = 6,
    IrSensorMode_Count = 7,
};

enum OutputMode
{
    OutputMode_None,
    OutputMode_Auto,
    OutputMode_OneShot,
    OutputMode_CountMax,
};

enum OutputApiTypes
{
    OutputApiTypes_State,
    OutputApiTypes_States,
    OutputApiTypes_CountMax,
};

enum PadTypes
{
    PadTypes_Npad,
    PadTypes_CountMax,
};

enum NpadTypes
{
    NpadTypes_JoyRight,
    NpadTypes_JoyLeft,
    NpadTypes_FullKey,
    NpadTypes_JoyDual,
    NpadTypes_Handheld,
    NpadTypes_CountMax,
};

enum NpadSettingTypes
{
    NpadSettingTypes_JoyRight,
    NpadSettingTypes_JoyLeft,
    NpadSettingTypes_FullKey,
    NpadSettingTypes_JoyDual,
    NpadSettingTypes_Handheld,
    NpadSettingTypes_CountMax,
};

enum OutputLevel
{
    OutputLevel_Normal,
    OutputLevel_Detail,
    OutputLevel_CountMax,
};

const char* DeviceStateName[3] =
{
    "Available",
    "Unsupported",
    "Unconnected",
};

const char* ProcessorStateName[2] =
{
    "Stopped",
    "Running",
};

const char* OutputTypeName[OutputMode_CountMax] =
{
    "None",
    "Auto",
    "OneShot",
};

const char* OutputApiTypeName[OutputApiTypes_CountMax] =
{
    "GetState",
    "GetStates",
};

const char* NpadTypeName[NpadTypes_CountMax] =
{
    "JoyRight",
    "JoyLeft",
    "FullKey",
    "JoyDual",
    "Handheld",
};

const char* NpadSettingTypeName[NpadSettingTypes_CountMax] =
{
    "JoyRight",
    "JoyLeft",
    "FullKey",
    "JoyDual",
    "Handheld",
};

const char* AmbientNoiseLevelName[4] =
{
    "Low",
    "Middle",
    "High",
    "Unknown",
};

const char* AccuracyLevelName[3] =
{
    "Low",
    "Middle",
    "High",
};

const int MenuHeight[IrSensorMode_Count] = { 11, 13, 10, 1, 2, 2, 2};
const int MenuOutputLength = 4;
const int MenuInitializedLength = 3;
const int FirmwareUpdateRetryCountMax = 300;
const int FpsTableLength = 2;
const int FpsTable[FpsTableLength] = { 60, 30 };

struct Npad
{
    typedef nn::hid::NpadIdType Id;
    typedef nn::hid::NpadJoyRightState RightState;
    typedef nn::hid::NpadJoyLeftState LeftState;
    typedef nn::hid::NpadFullKeyState FullkeyState;
    typedef nn::hid::NpadJoyDualState JoyDualState;
    typedef nn::hid::NpadHandheldState HandheldState;
    typedef nn::hid::NpadButton Button;
};

struct CameraViewer
{
    // 各サイズの画像に対してのテクスチャデータ
    nn::gfx::Texture texture[5];
    nn::gfx::TextureView textureView[5];
    nn::gfx::DescriptorSlot textureDescriptor[5];

    // HandAnalysis 向けのテクスチャデータ
    nn::gfx::Texture textureHand;
    nn::gfx::TextureView textureViewHand;
    nn::gfx::DescriptorSlot textureDescriptorHand;

    nn::gfx::Sampler sampler;
    nn::gfx::DescriptorSlot samplerDescriptor;
    void* cameraImageBuffer;
    nn::gfx::Buffer copiedImageBuffer;
};

struct IrState
{
    IrSensorMode currentProcessor, nextProcessor;
    nn::irsensor::MomentProcessorState momentProcessorState[nn::irsensor::MomentProcessorStateCountMax];
    nn::irsensor::MomentProcessorConfig momentProcessorConfig;
    nn::irsensor::Rect momentProcessorWoi;
    nn::Result momentApiResult;
    int momentApiOutCount;
    nn::irsensor::ClusteringProcessorState clusteringProcessorState[nn::irsensor::ClusteringProcessorStateCountMax];
    nn::irsensor::ClusteringProcessorConfig clusteringProcessorConfig;
    nn::irsensor::Rect clusteringProcessorWoi;
    nn::Result clusteringApiResult;
    int clusteringApiOutCount;
    nn::irsensor::ImageTransferProcessorFormat format;
    nn::irsensor::ImageTransferProcessorState imageTransferProcessorState;
    nn::irsensor::ImageTransferProcessorExConfig imageTransferProcessorConfigNext;
    nn::irsensor::ImageTransferProcessorExConfig imageTransferProcessorConfigCurrent;
    nn::Result imageTransferApiResult;
    void* imageTransferWorkBuffer;
    int64_t imageTransferPrevSamplingNumber;
    int64_t imageTransferGetDataTime;
    int64_t imageTransferFrameInterval;
    nn::irsensor::PointingProcessorState pointingProcessorState[nn::irsensor::PointingProcessorStateCountMax];
    nn::irsensor::PointingProcessorMarkerState pointingProcessorMarkerState[nn::irsensor::PointingProcessorStateCountMax];
    nn::Result pointingApiResult;
    int pointingApiOutCount;
    nn::irsensor::HandAnalysisImageState handAnalysisImageState;
    nn::irsensor::HandAnalysisSilhouetteState handAnalysisSilhouetteState;
    nn::irsensor::HandAnalysisConfig handAnalysisConfigNext;
    nn::irsensor::HandAnalysisConfig handAnalysisConfigCurrent;
    nn::Result handAnalysisApiResult;
    PolygonProperties handAnalysisPolygon;
    nn::irsensor::IrLedProcessorConfig irLedProcessorConfig;
    nn::Result irLedApiResult;
    nn::irsensor::AdaptiveClusteringProcessorState adaptiveClusteringProcessorState[nn::irsensor::AdaptiveClusteringProcessorStateCountMax];
    nn::irsensor::AdaptiveClusteringProcessorConfig adaptiveClusteringProcessorConfig;
    int adaptiveClusteringApiOutCount;
    nn::Result adaptiveClusteringApiResult;
};

struct DeviceState
{
    int padMenuSelect;
    int padOutputMenuSelect;
    int padInitializedMenuSelect;
    nn::Result firmwareUpdateStatusResult;
    int firmwareUpdateTrialCount;
    PadTypes padTypes;
    NpadTypes npadTypes;
    NpadSettingTypes npadSettingTypes;
    nn::hid::NpadButtonSet buttonDownSetJoy;
    nn::hid::NpadButtonSet buttonDownSetJoyRaw;
    IrState irState;
    nn::irsensor::IrCameraStatus irCameraStatus;
    bool isCameraStatusValid;
    nn::irsensor::ImageProcessorStatus irProcessorStatus;
    bool isProcessorStatusValid;
    IrSensorApiTestToolState irToolState;
    CameraViewer cameraViewer;
    nn::irsensor::IrCameraHandle irCameraHandle;
    OutputMode outMode;
    OutputMode outCurrentMode;
    OutputApiTypes outApiTypes;
    OutputApiTypes outCurrentApiTypes;
    int outCountMax;
    int outCurrentCountMax;
    OutputLevel outputLevelCurrent;
    OutputLevel outputLevelNext;
    float samplingDropRatio;
    float dataDropRatio;
    float dataDropRatioViaSamplingNum;
    int64_t prevSamplingNum;
    int64_t latestSamplingNum;
    int64_t latestSampleCount;
    int updateCounter;
    float averagePlr;
    int maxPlr;
    int burstDropCount;
    int burstDropCountWorst;
    float burstDropCountWorstAve;
    int burstDropCountWorstCurrent;
    int burstDropCountWorstMax;
    float aveFrameIntervalMs;
    int64_t frameIntervalMs;
    int frameIntervalCount;
    int64_t prevIntervalUpdateTime;
};

}
