﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <SampleShaderHeader.glsl>

VARYING_QUALIFIER Varying
{
    vec2 texCoord;
} VARYING_INSTANCE;

#if NN_GFX_VERTEX_SHADER
out gl_PerVertex
{
    vec4 gl_Position;
};

layout( location = 0 ) in vec4 i_Position;
layout( location = 1 ) in vec2 i_TexCoord;

layout( std140 ) uniform VariationConstantsVs
{
    vec4 posScale;
};

layout( std140 ) uniform Matrix
{
    mat4 world;
};

void main()
{
    gl_Position = i_Position * posScale * world;

    Out.texCoord = i_TexCoord.xy;
}
#endif

#if NN_GFX_PIXEL_SHADER
layout( location = 0 ) out vec4 o_Color;

uniform sampler2D tex;

layout( std140 ) uniform VariationConstantsPs
{
    bool useTexture;
    bool useMaterial;
};

layout( std140 ) uniform Mat
{
    vec4 color;
};

void main()
{
    vec4 out_color = vec4( 0 );

    if( useTexture )
    {
        vec4 tex_color = texture( tex, In.texCoord );
        out_color += tex_color;
    }

    if( useMaterial )
    {
        out_color += color;
    }

    o_Color = out_color;
}
#endif
