﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------
//  nninitStartup 動作確認テスト
//-----------------------------------------------------------------------------

#include <nn/TargetConfigs/build_Compiler.h>
#include <nn/nn_SdkText.h>

#if defined(NN_BUILD_CONFIG_COMPILER_VC)
    // 日本語以外の環境で表示される文字コードエンコーディングに関する警告の抑制
    #pragma warning( disable : 4566 )
#endif

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/init.h>

#include <nnt/nntest.h>

namespace nn { namespace os {
    uintptr_t GetMemoryHeapAddress() NN_NOEXCEPT;
    size_t    GetMemoryHeapSize()    NN_NOEXCEPT;
}}  // namespace nn::os


namespace nnt { namespace init { namespace startup {

//-----------------------------------------------------------------------------
// デフォルトの nninitStartup() が呼ばれたかどうかをチェック
//
TEST(NnInitStartup, CheckCalledDefaultNnInitStartup)
{
    NN_LOG(NN_TEXT("デフォルトの nninitStartup() が呼ばれたか ... "));

    uintptr_t heapAdrs = nn::os::GetMemoryHeapAddress();
    size_t    heapSize = nn::os::GetMemoryHeapSize();

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    if (heapSize > 0)
#elif defined(NN_BUILD_CONFIG_OS_WIN)
    if (heapSize == 0)
#endif
    {
        NN_LOG("OK\n");
        SUCCEED();
    }
    else
    {
        NN_LOG("NG\n");
        ADD_FAILURE();
    }

    NN_LOG("Heap Address = %p\n", heapAdrs);
    NN_LOG("Heap Size    = %p\n", heapSize);
}

//-----------------------------------------------------------------------------

}}} // namespace nnt::init::startup
