﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_Mutex.h>
#include <memory>

namespace nnt { namespace sfutil {

class NonRecursiveMutex
    : public nn::os::Mutex
{
public:
    NonRecursiveMutex() NN_NOEXCEPT
        : Mutex(false)
    {
    }
};

class RecursiveMutex
    : public nn::os::Mutex
{
public:
    RecursiveMutex() NN_NOEXCEPT
        : Mutex(true)
    {
    }
};

namespace detail {

    template <typename Mutex>
    struct MutexUnlocker
    {
        void operator()(Mutex* p) const NN_NOEXCEPT
        {
            p->Unlock();
        }
    };

}

template <typename Mutex>
std::unique_ptr<Mutex, detail::MutexUnlocker<Mutex>> MakeLockGuard(Mutex& mutex) NN_NOEXCEPT
{
    mutex.Lock();
    return std::unique_ptr<Mutex, detail::MutexUnlocker<Mutex>>(std::addressof(mutex));
}

}}
