﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// プラットフォームによる実装分岐用のマクロを自動定義します。
#if defined(CAFE)
    #define NNT_NFP_PLATFORM_CAFE
#elif defined(NN_PLATFORM_CTR)
    #define NNT_NFP_PLATFORM_CTR
#elif defined(NN_NINTENDO_SDK)
    #define NNT_NFP_PLATFORM_NX

    //NFPライブラリのバージョン
    #define NNT_NFP_LIB_VERSION_STUB  // STUB版で実装される機能のテストを実行する時に有効にする
    #define NNT_NFP_LIB_VERSION_ALPHA // α版で実装される機能のテストを実行する時に有効にする
    #define NNT_NFP_LIB_VERSION_BETA  // β版で実装される機能のテストを実行する時に有効にする
//    #define NNT_NFP_LIB_VERSION_FINAL // 実装時期が未定

    // Mii機能
    #define NNT_NFP_LIB_MII_ENABLE // Mii関連のテストを実行するときに有効にする

#else
    #error "サポートされないプラットフォームです。"
#endif //defined(CAFE)

// プラットフォーム毎に必要なファイルをインクルードします。
#include <nn/nfp.h>
#if defined(NNT_NFP_PLATFORM_CTR)
    #include <nn/cfg.h>
    #include <nn/cfg/CTR/cfg_ApiInit.h>
    #include <nn/cfg/CTR/detail/cfg_Keys.h>
    #include <nn/cfg/CTR/detail/cfg_DataStructures.h>
    #include <nn/fnd.h>
    #include <nn/mii/mii_StoreDataAccessor.h>
    #include <nn/nwm.h>
    #include <nn/os.h>
    #include <nn/ptm/CTR/ptm_ApiSysmenu.h>
    #include <nn/nfp/nfp_TypesPrivate.h>
    #include <nn/nfp/nfp_ResultPrivate.h>
    #include <nn/nfp/CTR/nfp_ApiApplet.h>
    #include <nn/nfp/CTR/nfp_ApiDebug.h>
    #include <nn/nfp/CTR/nfp_ApiPrivate.h>
#elif defined(NNT_NFP_PLATFORM_CAFE)
    #include <cafe/os.h>
    #include <nn/nfp/private/nfp_ApiPrivate.h>
#elif defined(NNT_NFP_PLATFORM_NX)
    #include <nn/nfp/nfp_DebugApi.h>
    #include <nn/nfp/nfp_DebugTypes.h>
    #include <nn/nfp/nfp_PrivateApi.h>
    #include <nn/nfp/nfp_PrivateTypes.h>
    #include <nn/nfp/nfp_ErrorApi.h>
#endif //defined(NNT_NFP_PLATFORM_NX)

// エラーの要因が同じでプラットフォームによってエラーの名前が違うResultを定義します。
#if defined(NNT_NFP_PLATFORM_NX)
    #define RESULT_ERROR_INVALID_DEVICE_STATE ResultInvalidDeviceState
#else
    #define RESULT_ERROR_INVALID_DEVICE_STATE ResultInvalidOperation
#endif

namespace nnt { namespace nfp {
    // 読み書きの失敗時にリトライする回数と待機時間 (ms) です。
    const int RetryCountMax           = 5;
    const int RetryInterval           = 100;

    // デフォルトのタイムアウト時間 (ms) です。
    const int ActivateTimeout         = 5000;
    const int DeactivateTimeout       = 5000;
    const int AvailabilityChangeTimeout = 5000;
    const int ConnectTimeout          = 5000;
    const int DisconnectTimeout       = 5000;

    // バッファに要求されるアライメントはプラットフォームによって異なります。
    #if defined(NNT_NFP_PLATFORM_CTR)
        const size_t IpcAlignment = nn::nfp::BACKUP_BUFFER_ALIGNMENT;
    #elif defined(NNT_NFP_PLATFORM_CAFE)
        const size_t IpcAlignment = FS_IO_BUFFER_ALIGN;
    #elif defined(NNT_NFP_PLATFORM_NX)
        const size_t IpcAlignment = 4;
    #endif // defined(NNT_NFP_PLATFORM_NX)

    // 各プラットフォームにおけるテストの TitleID です。
    #if defined(NNT_NFP_PLATFORM_CTR)
        const bit64 TestTitleId = 0x000400000FF3FF00ULL;
        const nn::nfp::PlatformType PLATFORM = nn::nfp::PlatformType_Ctr;
    #elif defined(NNT_NFP_PLATFORM_NX)
        const nn::ncm::ApplicationId TestApplicationId = {0x0100000000003000ULL};
        const nn::nfp::PlatformType Platform = nn::nfp::PlatformType_Nx;
    #endif // defined(NNT_NFP_PLATFORM_NX)

    // テストに使用するタグの情報です。
    const nn::Bit8  TestCharacterId[nn::nfp::CharacterIdSize] = { 0x00, 0x02, 0x00 };
    const nn::Bit8  TestSeriesId       = 0x00;
    const nn::Bit16 TestNumberingId    = 0x0001;
    const nn::Bit16 TestNfpType        = 0x00;
    const nn::Bit16 TestNfpVersion     = 0x00;
    const nn::Bit16 TestNoftVersion    = nn::nfp::FormatVersion_NoftV2;
    const int       TestMiiDataSize    = 96;
}} // end of namespace nnt::nfp
