﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ncm/ncm_ContentMetaId.h>

#define NNT_DETAIL_LCS_DEFINE_APPLICATION(Name, Id) \
    const nn::ncm::ApplicationId Name = { UINT64_C(Id) }

namespace nnt { namespace lcs { namespace Application
{
    NNT_DETAIL_LCS_DEFINE_APPLICATION(Invalid, 0x0000000000000000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(Standalone01, 0x01004b9000500000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(Standalone02, 0x01004b9000501000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(Matching01, 0x01004b9000600000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(Matching02, 0x01004b9000601000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(Matching03, 0x01004b9000602000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(Matching04, 0x01004b9000603000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(Matching05, 0x01004b9000604000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShare01, 0x01004b9000700000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShare02, 0x01004b9000701000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShare03, 0x01004b9000702000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShare04, 0x01004b9000703000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShare05, 0x01004b9000704000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShare06, 0x01004b9000705000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShare07, 0x01004b9000706000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShare08, 0x01004b9000707000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShare09, 0x01004b9000708000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShare10, 0x01004b9000709000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShare11, 0x01004b900070a000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShare12, 0x01004b900070b000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShare13, 0x01004b900070c000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShare14, 0x01004b900070d000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(HostMigration01, 0x01004b9000800000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(HostMigration02, 0x01004b9000801000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(HostMigration03, 0x01004b9000802000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShareFailure01, 0x01004b9000900000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShareFailure02, 0x01004b9000901000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShareFailure03, 0x01004b9000902000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShareFailure04, 0x01004b9000903000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShareFailure05, 0x01004b9000904000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(PatchShareFailure06, 0x01004b9000905000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(Lup01, 0x01004b9000a00000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(Lup02, 0x01004b9000a01000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(Lup03, 0x01004b9000a02000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(Fork01, 0x01004b9000b00000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(Fork02, 0x01004b9000b01000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(Fork03, 0x01004b9000b02000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(Fork04, 0x01004b9000b03000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(KeyGeneration00, 0x01004b9000c00000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(KeyGeneration02, 0x01004b9000c02000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(KeyGeneration03, 0x01004b9000c03000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(KeyGeneration04, 0x01004b9000c04000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(SystemDeliveryProtocol01, 0x01004b9000d00000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(SystemDeliveryProtocol02, 0x01004b9000d01000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(ExFat01, 0x01004b9000e00000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(ExFat02, 0x01004b9000e01000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(ApplicationRecord01, 0x01004b9000f00000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(ApplicationRecord02, 0x01004b9000f01000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(LupEula01, 0x01004b9001000000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(Timing01, 0x01004b9001100000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(Timing02, 0x01004b9001101000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(StorageSpace01, 0x01004b9001200000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(StorageSpaceAlbumSpace, 0x01004b90012fd000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(StorageSpaceSavedataSpace, 0x01004b90012fe000);
    NNT_DETAIL_LCS_DEFINE_APPLICATION(StorageSpacePatchSpace, 0x01004b90012ff000);

}}} // namespace nnt::lcs::Application
