﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nnt { namespace lcs
{
    /**
     * @brief       Runner スクリプトにテスト終了後の操作を要求します。
     */
    void RequestReboot() NN_NOEXCEPT;

    /**
     * @brief       Runner スクリプトにテスト終了後のテスト再実行を要求します。
     */
    void RequestResume() NN_NOEXCEPT;

    /**
     * @brief       Runner スクリプトにテスト終了後のパラメータ変更を要求します。
     * @param[in]   name                名前です。
     * @param[in]   key                 キー値です。
     * @param[in]   value               値です。
     * @return
     */
    void RequestFirmwareDebugParameterUpdate(
        const char* name, const char* key, int value) NN_NOEXCEPT;

    /**
     * @brief       Runner スクリプトにテスト終了後のパラメータ変更を要求します。
     * @param[in]   version             値です。
     * @return
     */
    void RequestApplicationDeliveryProtocolVersionUpdate(int version) NN_NOEXCEPT;

    /**
     * @brief       Runner スクリプトにテスト終了後の DevMenuCommandSystem 実行を要求します。
     * @param[in]   argument            DevMenuCommandSystem のコマンドライン引数です。
     * @return
     */
    void RequestDevMenuCommandSystem(const char* argument) NN_NOEXCEPT;

}} // namespace nnt::lcs
