﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <iostream>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nnt/gfx/testGfx_PngCommon.h>

#include <string>
#include <vector>

namespace nnt {
namespace gfx {

/**
* @brief テスト結果HTML作成クラス
*
* @details
*/
class NntGfxResultHtml
{
public:
    /**
     * @brief テーブルのセルの内容
     *
     * @details htmlでの”<td>”になります。
     */
    typedef struct TableData
    {
        int width;              //!< 横幅
        int height;             //!< 縦幅
        std::string outValue;   //!< 出力する文字列
    }
    TableData;

    /**
     * @brief テーブルの行
     *
     * @details htmlでの”<tr>”になります。
     */
    typedef struct TableLine
    {
        std::vector<TableData> dataArray;   //!< セルの配列
    }
    TableLine;

    /**
     * @brief テーブル(表)
     *
     * @details htmlでの”<table>”になります。
     */
    typedef struct Table
    {
        std::string headerName;             //!< 見出しの名前
        std::vector<TableLine> lineArray;   //!< 行の配列
    }
    Table;


    /**
     * @brief HTML作成
     *
     * @param[in]  pPath     出力パス
     * @return  保存に成功したときtrueを返します。
    */
    bool CreateResultHtml( const char* pPath );

public:

    /**
     * @brief HTMLテーブル配列の取得
     *
     * @return  テーブル配列を返します。
    */
    std::vector<Table>* GetArray() { return &m_TableArray; }

private:
    std::vector<Table> m_TableArray;    //!< HTMLテーブル配列
};



}
}
