﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nnt {
namespace gfx {

struct PNG_IHDR
{
    uint32_t width;            //!< イメージの横幅
    uint32_t height;           //!<  イメージの縦幅
    uint8_t bitDepth;          //!<  ビット深度(1, 2, 4, 8, or 16 bits/channel)
    uint8_t colorType;         //!<  カラータイプ
    uint8_t compressionType;   //!<  圧縮手法
    uint8_t filterType;        //!<  フィルター手法
    uint8_t interlaceType;     //!<  インターレース手法
    uint8_t channels;          //!<  チャンネル数

    PNG_IHDR()
        : width(0)
        , height(0)
        , bitDepth(1)
        , colorType(0)
        , compressionType(0)
        , filterType(0)
        , interlaceType(0)
    {
    }

    /**
     * @brief ピクセル深度の取得
     *
     * @return     ピクセル深度を返します。
    */
    uint8_t GetPixelDepth() const { return bitDepth * channels; }

    /**
     * @brief 1行あたりのバイト数を取得
     *
     * @return     1行あたりのバイト数を返します。
    */
    uint32_t GetRowBytes() const { return ((width * static_cast<uint32_t>(GetPixelDepth()) + 7) >> 3); }
};

}
}
