﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2009, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */

#pragma once

#include <nn/fs.h>
#include <nn/ioslibc/types.h>
#include <nn/istorage/istorage.h>

#include <ios>
#include <iostream>
#include <fstream>

using namespace nn;

USING_ISTORAGE_NAMESPACE

#define ESCORE_UTIL_NAMESPACE nnt::escore::util
#define USING_ESCORE_UTIL_NAMESPACE \
    using namespace ESCORE_UTIL_NAMESPACE;

namespace nnt { namespace escore { namespace util {

    class MemoryInputStream : public IInputStream
    {
      private:
        const u8 *rBuf;
        s64 rSize, rPos;

      public:
        MemoryInputStream(const void *buffer, u32 size);
        virtual ~MemoryInputStream();

        virtual RESULT_NAMESPACE::Result TryRead(s32 *pOut, void *buffer, u32 size);
        virtual RESULT_NAMESPACE::Result TrySetPosition(s64 position);
        virtual RESULT_NAMESPACE::Result TryGetPosition(s64 *pOut) const;
        virtual RESULT_NAMESPACE::Result TryGetSize(s64 *pOut) const;
    };


    class MemoryOutputStream : public IOutputStream
    {
      private:
        u8 *wBuf;
        s64 wSize, wPos;

      public:
        MemoryOutputStream(void *buffer, u32 size);
        virtual ~MemoryOutputStream();

        virtual RESULT_NAMESPACE::Result TryWrite(s32 *pOut, const void *buffer, u32 size, bool);
        virtual RESULT_NAMESPACE::Result TrySetPosition(s64 position);
        virtual RESULT_NAMESPACE::Result TryGetPosition(s64 *pOut) const;
        virtual RESULT_NAMESPACE::Result TryGetSize(s64 *pOut) const;
    };


    enum OpenMode
    {
        OPEN_MODE_READ = 1,
        OPEN_MODE_WRITE = 2,
        OPEN_MODE_CREATE = 4
    };


    enum PositionBase
    {
        POSITION_BASE_BEGIN,
        POSITION_BASE_CURRENT,
        POSITION_BASE_END,
    };


    /*
     * FileStream class for Linux
     */
    class FileStream : public IInputStream, public IOutputStream
    {
      public:
        FileStream() : f_Position(0), f_Size(0), f_Stream(NULL) {};
        ~FileStream() {
            if (f_Stream != NULL) {
                nn::fs::CloseFile(*f_Stream);
                delete f_Stream;
            }
        };
        FileStream(const char *pathName, u32 openMode) { Initialize(pathName, openMode); };

        virtual void Initialize(const char *pathName, u32 openMode);
        virtual RESULT_NAMESPACE::Result TryInitialize(const char *pathName, u32 openMode);
        virtual s32 Read(void *buffer, size_t size);
        virtual RESULT_NAMESPACE::Result TryRead(s32 *pOut, void *buffer, u32 size);
        virtual s32 Write(const void *buffer, size_t size, bool flush=true);
        virtual RESULT_NAMESPACE::Result TryWrite(s32 *pOut, const void *buffer, u32 size, bool flush=true);
        virtual void Seek(s64 position, PositionBase base);
        virtual RESULT_NAMESPACE::Result TrySeek(s64 position, PositionBase base);
        virtual RESULT_NAMESPACE::Result TryGetPosition(s64 *pOut) const;
        virtual RESULT_NAMESPACE::Result TrySetPosition(s64 position);
        virtual RESULT_NAMESPACE::Result TryGetSize(s64 *pOut) const;
        virtual RESULT_NAMESPACE::Result TrySetSize(s64 size);
        virtual void Finalize();

      protected:
        s64 f_Position;
        s64 f_Size;
        OpenMode f_Mode;
        nn::fs::FileHandle *f_Stream;
    };
}}}
