﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstddef> // nullptr, std::size_t
#include <cstdlib> // std::malloc, std::free

#include <nnt/codecUtil/testCodec_TestBase.h>
#include <nnt/codecUtil/testCodec_NativeOpusEncoder.h>

namespace nnt {
namespace codec {

template <typename EncoderType>
class NativeOpusEncoderBase
{
protected:
    NativeOpusEncoderBase() NN_NOEXCEPT
        : encoder()
        , encoderWorkBufferAddress(nullptr)
        , encoderWorkBufferSize(0)
    {}

    virtual ~NativeOpusEncoderBase() NN_NOEXCEPT
    {
        if (encoder.IsInitialized())
        {
            encoder.Finalize();
        }
        if (nullptr != encoderWorkBufferAddress)
        {
            std::free(encoderWorkBufferAddress);
        }
        encoderWorkBufferAddress = nullptr;
    }

    void Initialize(const TestParameterSet& parameterSet, bool alloc = true) NN_NOEXCEPT
    {
        // Define some aliases
        const int& sampleRate = parameterSet.sampleRate;
        const int& streamCount = parameterSet.streamCount;
        const int& coupledStreamCount = parameterSet.coupledStreamCount;
        NN_ASSERT_NOT_EQUAL(sampleRate, 0);
        NN_ASSERT_LESS_EQUAL(coupledStreamCount, streamCount);
        // Initializing
        encoderWorkBufferSize = encoder.GetWorkBufferSize(sampleRate, streamCount, coupledStreamCount);
        if (alloc)
        {
            encoderWorkBufferAddress = std::malloc(encoderWorkBufferSize);
            ASSERT_NE(nullptr, encoderWorkBufferAddress);
        }
        // encoder.Initialize() を呼ぶかどうかはテスト次第なので、ここではしない。
    }

    void Finalize() NN_NOEXCEPT
    {
        if (encoder.IsInitialized())
        {
            encoder.Finalize();
        }
        if (nullptr != encoderWorkBufferAddress)
        {
            std::free(encoderWorkBufferAddress);
        }
        encoderWorkBufferAddress = nullptr;
        encoderWorkBufferSize = 0;
    }

    NativeOpusEncoder<EncoderType> encoder;
    void* encoderWorkBufferAddress;
    std::size_t encoderWorkBufferSize;
};

}} // nnt::codec
