﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <nn/atk.h>
#include <nnt/atkUtil/testAtk_Util.h>

namespace nnt { namespace atk { namespace util {

class ProfileStatistics
{
public:
    explicit ProfileStatistics(int offset) NN_NOEXCEPT;
    ProfileStatistics() NN_NOEXCEPT;

    void AddProfile(nn::atk::SoundProfile& profile, const nn::os::Tick previousAtkFrameProcessBegin) NN_NOEXCEPT;

    void PrintMeanProfile(const char* label) NN_NOEXCEPT;
    void PrintMeanProfile() NN_NOEXCEPT;
    void PrintMaxProfile(const char* label) NN_NOEXCEPT;
    void PrintMaxProfile() NN_NOEXCEPT;

    void Reset() NN_NOEXCEPT;

private:
    nnt::atk::util::Statistics<int64_t> m_TotalVoice;
    nnt::atk::util::Statistics<int64_t> m_NwFrameProcess;
    nnt::atk::util::Statistics<int64_t> m_RendererFrameProcess;
    nnt::atk::util::Statistics<int64_t> m_VoiceProcess;
    nnt::atk::util::Statistics<float> m_VoiceProcessPerVoice;
    nnt::atk::util::Statistics<int64_t> m_MainMixProcess;
    nnt::atk::util::Statistics<int64_t> m_FinalMixProcess;
    nnt::atk::util::Statistics<int64_t> m_SinkProcess;
    nnt::atk::util::Statistics<int64_t> m_NwFrameProcessInterval;
    int m_OffsetCount;
};

}}}
