﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/atk.h>
#include <nn/mem.h>
#include <nn/nn_Abort.h>
#include <nn/util/util_FormatString.h>

namespace nnt{ namespace atk { namespace util {
class FileLogger
{
public:
    enum OpenOption
    {
        OpenOption_OverWrite,
        OpenOption_Append
    };

    FileLogger() NN_NOEXCEPT;
    explicit FileLogger(const char* filePath) NN_NOEXCEPT;
    FileLogger(const char* filePath, OpenOption option) NN_NOEXCEPT;
    ~FileLogger() NN_NOEXCEPT;

    nn::Result Open(const char* filePath, OpenOption option) NN_NOEXCEPT;
    nn::Result Write(const char* pFormat, ...) NN_NOEXCEPT;
    nn::Result Flush() NN_NOEXCEPT;
    void Close() NN_NOEXCEPT;
    bool IsOpened() const NN_NOEXCEPT;

private:
    // ログのファイル書き込みを開始するサイズです
    // 一回の Write では WriteThresholdSize 以下の大きさのログを書き込むようにしてください
    static const size_t WriteThresholdSize = 4 * 1024;
    static const size_t LogBufferSize = WriteThresholdSize * 2;
    // ログ記録用のバッファ、メッセージをためて、
    // WriteThresholdSize 以上の大きさのメッセージがたまるとファイル書き込みが行われます
    char m_LogBuffer[LogBufferSize];
    nn::fs::FileHandle m_Handle;
    nn::os::Mutex m_Mutex;
    bool m_IsOpened;
};

}}}
