﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <cstdlib>

#include <nn/util/util_FormatString.h>
#include <nn/fs.h>
#include <nn/nn_Log.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Assert.h>

#include "testImageJpeg_Path.h"

namespace nnt { namespace image { namespace jpeg { namespace io {

namespace // Anonymous
{
const char *kResourcePath = "\\Externals\\Binaries\\TestData\\nn_image_jpeg";
const char *kDestPathBase = "C:\\Windows\\Temp";

// ディレクトリ探査の最大回数 kMaxDirSearch に妥当性は特にないので、回数は変更可能
const uint32_t kMaxDirSearch = 0xFFFF;

} // ~Anonymous

bool GetAssetDirectoryPath(char *pPathBuffer, size_t bufferSize)
{
    const size_t rootPathLength = std::strlen(NNT_JPEG_SIGLO_ROOT);
    const size_t resoucePathLength = std::strlen(kResourcePath);
    if (rootPathLength + resoucePathLength > bufferSize - 1)
    {
        NN_LOG("Too short path buffer: %d\n", rootPathLength);
        return false;
    }

    strcpy(pPathBuffer, NNT_JPEG_SIGLO_ROOT);
    NN_LOG("SigloRoot: %s\n", pPathBuffer);

    // Now we got $SIGLO_ROOT
    strcpy(pPathBuffer + rootPathLength, kResourcePath);
    NN_LOG("AssetDirectory: %s\n", pPathBuffer);

    return true;
}

bool GetOutputDirectoryPath(char *path, size_t pathSize)
{
    // 親ディレクトリが存在するか調べる
    unsigned int l = nn::util::SNPrintf(path, pathSize, kDestPathBase);

    nn::fs::DirectoryEntryType directory;
    nn::Result fsResult = nn::fs::GetEntryType(&directory, path);

    NN_ABORT_UNLESS(fsResult.IsSuccess(), "Failed to open parent directory: %s\n", path);

    // 通し番号順に、存在していないディレクトリがあるか調べる
    for (uint32_t i = 0; i < kMaxDirSearch; i++)
    {
        nn::util::SNPrintf(path + l, pathSize - l, "\\SIGLO_JPEG_TEST_0x%08X", i);
        fsResult = nn::fs::GetEntryType(&directory, path);
        if(nn::fs::ResultPathNotFound::Includes(fsResult))
        {
            NN_LOG("OutputDirectory: %s\n", path);
            return true;
        }
        NN_ASSERT(fsResult.IsSuccess());
    }
    return false;
}

}}}}

