﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>

#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>

#include <nn/i2c/i2c.h>
#include <nn/i2c/i2c_BusDev.h> // Include development header not in nn/i2c/i2c.h

#include "test_Max77620.h"
#include "../Common/test_Util.h"

namespace {

const nn::i2c::I2cDevice      I2cDeviceName      = nn::i2c::I2cDevice::I2cDevice_Max77620Pmic;
const nn::Bit16               SlaveAddr    = 0x3c; // RTC: 0x68

// Codec registers
const uint8_t                 RegCid03[]      = {0x58, 0x59, 0x5a, 0x5b}; // CID0 - CID3
const uint8_t                 RegCid45[]      = {0x5c, 0x5d};             // CID4 - CID5
//const uint8_t                 ExpectedCid45[] = {0x35, 0x80};             // CID4 - CID5 の期待値

const int                     RegCid03Length  = sizeof(RegCid03) / sizeof(RegCid03[0]);
const int                     RegCid45Length  = sizeof(RegCid45) / sizeof(RegCid45[0]);
}

namespace nnt { namespace i2c { namespace max77620 {

//---------------------------------------------------------------------------
//  テスト用関数
//---------------------------------------------------------------------------

bool TEST_VariousSpeedModes( int targetBusIdx, const nn::i2c::SpeedMode* targetSpeedModes, int targetSpeedModeNum )
{
    nn::i2c::Initialize();

    nn::i2c::I2cSession i2c;

    for( int i = 0; i < targetSpeedModeNum; i++ )
    {
        NN_LOG("Test @ SpeedMode = %d [bps]\n", targetSpeedModes[i]);
        nn::i2c::OpenSessionForDev(&i2c, targetBusIdx, SlaveAddr, nn::i2c::AddressingMode_BitWidth7, targetSpeedModes[i]);

        for (int i = 0; i < RegCid03Length; i++)
        {
            // CID（シリアルナンバーなど）を表示。一意とは限らないので表示のみにし、比較テストはしない
            nnt::i2c::util::TestReadRegister(i2c,
                reinterpret_cast<const char*>(&RegCid03[i]),  sizeof(RegCid03[i]),
                nullptr, 1
                );
        }
        for (int i = 0; i < RegCid45Length; i++)
        {
            // CID4, CID5 も変更されうるので、値だけ表示し、期待値とのチェックはスキップ
            nnt::i2c::util::TestReadRegister(i2c,
                reinterpret_cast<const char*>(&RegCid45[i]),        sizeof(RegCid45[i]),
                nullptr, 1
                );
        }
        if (::testing::Test::HasFatalFailure())
        {
            nn::i2c::CloseSession(i2c);
            nn::i2c::Finalize();
            return false;
        }

        nn::i2c::CloseSession(i2c);
    }

    nn::i2c::Finalize();
    return true;
}

bool TEST_I2cDeviceAccess()
{
    nn::i2c::Initialize();

    nn::i2c::I2cSession i2c;

    nn::i2c::OpenSession(&i2c, I2cDeviceName);

    for (int i = 0; i < RegCid03Length; i++)
    {
        // CID（シリアルナンバーなど）を表示。一意とは限らないので表示のみにし、比較テストはしない
        nnt::i2c::util::TestReadRegister(i2c,
            reinterpret_cast<const char*>(&RegCid03[i]),  sizeof(RegCid03[i]),
            nullptr, 1
            );
    }
    for (int i = 0; i < RegCid45Length; i++)
    {
        // CID4, CID5 も変更されうるので、値だけ表示し、期待値とのチェックはスキップ
        nnt::i2c::util::TestReadRegister(i2c,
            reinterpret_cast<const char*>(&RegCid45[i]),        sizeof(RegCid45[i]),
            nullptr, 1
            );
    }
    if (::testing::Test::HasFatalFailure())
    {
        nn::i2c::CloseSession(i2c);
        nn::i2c::Finalize();
        return false;
    }

    nn::i2c::CloseSession(i2c);

    nn::i2c::Finalize();
    return true;
}

}}}  // namespace nnt::i2c::max77620
