﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <cstdlib>

#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>

#include <nnt/nntest.h>

#include "test_ThreadHelper.h"

namespace {
const int    NumberOfCores            = 2;  // 利用するコアの数(TORIAEZU)
}

namespace nnt { namespace i2c { namespace util {

void ThreadHelper::CreateThread( int threadId ) NN_NOEXCEPT
{
    ASSERT_TRUE(m_ThreadFunction != nullptr);

    // スレッドセーフ性の検証のためコアを分けてスレッドを立てる
    auto result = nn::os::CreateThread(
        &m_Thread,
        m_ThreadFunction,
        nullptr,
        m_ThreadStack,
        ThreadStackSize,
        nn::os::DefaultThreadPriority,
        threadId % NumberOfCores
    );

    ASSERT_TRUE( result.IsSuccess() );
}

void ThreadHelper::StartThread() NN_NOEXCEPT
{
    nn::os::StartThread( &m_Thread );
}

void ThreadHelper::WaitThread() NN_NOEXCEPT
{
    nn::os::WaitThread( &m_Thread );
}

void ThreadHelper::DestroyThread() NN_NOEXCEPT
{
    nn::os::DestroyThread( &m_Thread );
}

void ThreadHelper::SetThreadFunction( ThreadFunction threadFunction ) NN_NOEXCEPT
{
    m_ThreadFunction = threadFunction;
}

}}}  // namespace nnt::i2c::util
