﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>

#include <nn/i2c/i2c.h>
#include <nn/result/result_HandlingUtility.h>

#include "tool_Tmp451.h"

namespace nnt { namespace i2c { namespace tmp451 {

struct AddressRegion
{
    uint8_t beginAddress;
    uint8_t endAddress;
};

const AddressRegion AddressRegions[] =
{
    { 0x00, 0x08 },
    { 0x10, 0x15 },
    { 0x19, 0x24 },
    { 0xFE, 0xFE },
};

nn::Result DumpRegisters()
{
    NN_LOG("[tmp451] Start to dump\n");

    nn::i2c::Initialize();

    nn::i2c::I2cSession i2c;
    uint8_t value = 0;

    nn::i2c::OpenSession(&i2c, nn::i2c::I2cDevice_Tmp451);

    for ( const AddressRegion& addressRegion : AddressRegions )
    {
        for ( uint8_t address = addressRegion.beginAddress; address <= addressRegion.endAddress; address++ )
        {
            NN_RESULT_DO(nn::i2c::ReadSingleRegister(&value, i2c, &address));
            NN_LOG("[tmp451] %02x : %02x\n", address, value);

            if ( address == 0xff )
            {
                break;
            }
        }
    }

    nn::i2c::CloseSession(i2c);

    nn::i2c::Finalize();

    NN_LOG("[tmp451] End\n");

    NN_RESULT_SUCCESS;
}

}}}  // namespace nnt::i2c::tmp451
