﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Net.Sockets;
using System.Threading;
using System.IO;

using Nintendo.Htcs;

namespace StressTestTool
{
    internal class Utils
    {
        public delegate void TestFunction(TcpClient client);

        public static void Send(TcpClient client, int size, int count = 1)
        {
            Console.WriteLine("Utils.Send start");
            using (var writer = new BinaryWriter(client.GetStream(), Encoding.ASCII, true))
            {
                foreach (var i in Enumerable.Range(1, count))
                {
                    // 送信データの用意
                    byte[] data = new byte[size];

                    // Bulk Send
                    writer.Write(data);
                    writer.Flush();
                    Console.WriteLine("Write complete ({0}/{1})", i, count);
                }
            }
            Console.WriteLine("Utils.Send end");
        }

        public static void Recv(TcpClient client, int size, int count = 1)
        {
            Console.WriteLine("Utils.Recv start");
            using (var reader = new BinaryReader(client.GetStream(), Encoding.ASCII, true))
            {
                foreach (var i in Enumerable.Range(1, count))
                {
                    byte[] data = reader.ReadBytes(size);
                    if (data.Length != size)
                    {
                        Console.WriteLine("Error: {0} bytes expected, but {1} bytes received.", size, data.Length);
                    }
                    Console.WriteLine("Read complete ({0}/{1})", i, count);
                }
            }
            Console.WriteLine("Utils.Recv end");
        }

        public static void Echo(TcpClient client, int size, int count = 1)
        {
            Console.WriteLine("Utils.Echo start");
            using (var reader = new BinaryReader(client.GetStream(), Encoding.ASCII, true))
            using (var writer = new BinaryWriter(client.GetStream(), Encoding.ASCII, true))
            {
                foreach (var i in Enumerable.Range(1, count))
                {
                    byte[] data = reader.ReadBytes(size);
                    if (data.Length != size)
                    {
                        Console.WriteLine("Error: {0} bytes expected, but {1} bytes received.", size, data.Length);
                    }
                    Console.WriteLine("Read complete ({0}/{1})", i, count);

                    writer.Write(data);
                    writer.Flush();
                    Console.WriteLine("Write complete ({0}/{1})", i, count);
                }
            }
            Console.WriteLine("Utils.Echo end");
        }
    }
}
