﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Net.Sockets;
using System.Threading;
using System.IO;

using Nintendo.Htcs;

namespace StressTestTool
{
    internal class SpecialCaseTest
    {
        private readonly string m_KeyString;
        private readonly HtcsCommunicator m_HtcsCommunicator;

        public SpecialCaseTest(string keyString, HtcsCommunicator htcsCommunicator)
        {
            m_KeyString = keyString;
            m_HtcsCommunicator = htcsCommunicator;
        }

        public void Start()
        {
            Console.WriteLine("\n\n[ParallelCommunicationByNotUsingTransferMemory] ----\n\n");
            ParallelCommunicationByNotUsingTransferMemory();
        }

        public void ParallelCommunicationByNotUsingTransferMemory()
        {
            const int ThreadCount = 16;
            TestServer[] servers = new TestServer[ThreadCount];

            foreach (int i in Enumerable.Range(0, ThreadCount))
            {
                servers[i] = new TestServer(0, "Echo" + i + "_" + m_KeyString, m_HtcsCommunicator, (client) => Utils.Echo(client, 57312, 1024));
                servers[i].Start();
            }

            foreach (int i in Enumerable.Range(0, ThreadCount))
            {
                servers[i].Wait();
            }
        }
    }
}
